package ch8.demoCompositeId;

import java.util.ArrayList;
import java.util.Collection;

import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

@Entity
public class Team {
	@EmbeddedId
	private IdTeam id;
	
	@OneToMany(mappedBy="team", cascade=CascadeType.MERGE)
	private Collection<Player> players = new ArrayList<Player>();
	
	@OneToOne
	@JoinColumns({
	   @JoinColumn(name="COACH_REFERENCE_1", referencedColumnName = "UNIQUE_PROPERTY_1"),
	   @JoinColumn(name="COACH_REFERENCE_2", referencedColumnName = "UNIQUE_PROPERTY_2")
	})
	private Coach coach;



	
	public Team(){}
	
	public IdTeam getId()
	{
		return id;
	}

	public void setId(IdTeam id)
	{
		this.id = id;
	}



	public Collection<Player> getPlayers() {
		return players;
	}

	public void setPlayers(Collection<Player> players) {
		this.players = players;
	}

	public void addPlayer(Player p){
		if (p.getTeam() != null)
			p.getTeam().getPlayers().remove(p);
		p.setTeam(this);
		this.getPlayers().add(p);
		// vous pouvez encore amliorer ce code et le rendre plus robuste
		// avec des exceptions applicatives par exemple
	}


	public Coach getCoach() {
		return coach;
	}

	public void setCoach(Coach coach) {
		this.coach = coach;
	}





}
