package ch8.demoFilter;

import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.OneToOne;
import javax.persistence.PostPersist;
import javax.persistence.PrePersist;

@Entity
@EntityListeners(Monitor.class)
public class Coach extends Person{
	@OneToOne
	private Team team;

	public Team getTeam() {
		return team;
	}

	public void setTeam(Team team) {
		this.team = team;
	}
	

	@PrePersist
	protected void notifyPersistenceRequest(){
		System.out.println(this.getName() + " sur le point d'tre rendu persistant");
	}
	
	@PostPersist
	protected void confirmPersistence(){
		System.out.println(this.getName() + " rendu persistant");
	}

}
