package ch8.demoFilter;

import javax.persistence.Basic;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
 

@Entity
@org.hibernate.annotations.FilterDef(
		name = "limitPlayerByHeight", 
		parameters = { 
				@org.hibernate.annotations.ParamDef(
						name = "height", type = "float") 
				}
		)
@org.hibernate.annotations.Filter(
	name = "limitPlayerByHeight",
	condition="HEIGHT > :height"
	)
public class Player extends Person{

	private int hasBeenMvpCount;
	
	private float height;

	@ManyToOne
	private Team team;

	public Player(){}

	public Team getTeam() {
		return team;
	}

	public void setTeam(Team team) {
		this.team = team;
	}

	public float getHeight() {
		return height;
	}

	public void setHeight(float height) {
		this.height = height;
	}

	public int getHasBeenMvpCount() {
		return hasBeenMvpCount;
	}

	public void setHasBeenMvpCount(int hasBeenMvpCount) {
		this.hasBeenMvpCount = hasBeenMvpCount;
	}
	
}
