package ch8.demoFormula;

import javax.persistence.Basic;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
 
@Entity
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@org.hibernate.annotations.DiscriminatorFormula(
		"case " +
		"when height is null then 'player' " +
		"when height > 2 then 'bigplayer' " +
		"else 'smallPlayer' end"
)
@DiscriminatorValue("player")
public class Player extends Person{

	@Basic(fetch=FetchType.LAZY)
	@org.hibernate.annotations.Formula(
			"select count(*) from GAME g where g.MVP_ID = ID"
	)
	private int hasBeenMvpCount;
	
	private float height;

	@ManyToOne
	private Team team;

	public Player(){}

	public Team getTeam() {
		return team;
	}

	public void setTeam(Team team) {
		this.team = team;
	}

	public float getHeight() {
		return height;
	}

	public void setHeight(float height) {
		this.height = height;
	}

	public int getHasBeenMvpCount() {
		return hasBeenMvpCount;
	}

	public void setHasBeenMvpCount(int hasBeenMvpCount) {
		this.hasBeenMvpCount = hasBeenMvpCount;
	}
	
}
