package ch8.demoFormula;

import java.util.ArrayList;
import java.util.Collection;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
public class Team {
	@Id
	@GeneratedValue(generator="SequenceStyleGenerator")
	@GenericGenerator(name="SequenceStyleGenerator", 
			strategy = "org.hibernate.id.enhanced.SequenceStyleGenerator",
		    parameters = {
	        @Parameter(name="optimizer", value="hilo"),
	        @Parameter(name="initial_value", value="1"),
	        @Parameter(name="increment_size", value="20")
	    })
	private int id;
	
	@Version
	private int version;
	
	@OneToMany(mappedBy="team", cascade=CascadeType.MERGE)
	private Collection<Player> players = new ArrayList<Player>();
	
	@OneToOne(mappedBy="team",cascade=CascadeType.MERGE)
	private Coach coach;
	
	private String name;

	public Team(String name){
		this.name = name;
	}
	
	public Team(){}
	
	public int getId()
	{
		return id;
	}

	public void setId(int id)
	{
		this.id = id;
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public Collection<Player> getPlayers() {
		return players;
	}

	public void setPlayers(Collection<Player> players) {
		this.players = players;
	}


	public Coach getCoach() {
		return coach;
	}

	public void setCoach(Coach c) {
		  // pas d'ancien coach
		  if (getCoach() == null && c != null){
		    this.coach = c;
		    c.setTeam(this);
		  }
		  else if (getCoach() != null && c == null){
		    getCoach().setTeam(null);
		    this.coach = c;
		  }
		  else if (getCoach() != null && c != null){
		    if (!(getCoach().equals(c))){
		      getCoach().setTeam(null);
		      c.setTeam(this);
		      this.coach = c;
		    }
		  }
	}
	
	public void addPlayer(Player p){
		if (p.getTeam() != null)
			p.getTeam().getPlayers().remove(p);
		p.setTeam(this);
		this.getPlayers().add(p);
		// vous pouvez encore amliorer ce code et le rendre plus robuste
		// avec des exceptions applicatives par exemple
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}



}
