package ch8.demoSql;

import javax.persistence.Entity;
import javax.persistence.NamedNativeQuery;
import javax.persistence.OneToOne;

import org.hibernate.annotations.Loader;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLUpdate;

@Entity
@SQLInsert( sql="insert into COACH (NAME, ID) values (upper(?), ?)")
@SQLUpdate( sql="update COACH set NAME = ?, TEAM_ID = ? WHERE id = ?")
@SQLDelete( sql="DELETE COACH WHERE id = ?")
@SQLDeleteAll( sql="DELETE COACH")
@Loader(namedQuery = "loadCoach")
@NamedNativeQuery(name="loadCoach", query="select ID , NAME, TEAM_ID from COACH where ID=?", resultClass = Coach.class)
public class Coach extends Person{
	@OneToOne
	private Team team;

	public Team getTeam() {
		return team;
	}

	public void setTeam(Team team) {
		this.team = team;
	}

}
