package ch8.demoSql;

import java.util.ArrayList;
import java.util.Collection;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLInsert;

@Entity
public class Team {
	@Id
	@GeneratedValue()
	private int id;
	
	@OneToMany//(mappedBy="team", cascade=CascadeType.MERGE)
	@JoinColumn(name="TEAM_ID")
	// n'a de sens que si l'association n'est pas bidirectionnelle
	@SQLInsert( sql="UPDATE /*test*/ PLAYER SET TEAM_ID = ? where id = ?")
	@SQLDelete( sql="UPDATE  PLAYER SET TEAM_ID = null where id = ?")
	private Collection<Player> players = new ArrayList<Player>();
	
	@OneToOne(mappedBy="team",cascade=CascadeType.MERGE)
	private Coach coach;
	
	private String name;

	public Team(String name){
		this.name = name;
	}
	
	public Team(){}
	
	public int getId()
	{
		return id;
	}

	public void setId(int id)
	{
		this.id = id;
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public Collection<Player> getPlayers() {
		return players;
	}

	public void setPlayers(Collection<Player> players) {
		this.players = players;
	}


	public Coach getCoach() {
		return coach;
	}

	public void setCoach(Coach c) {
		  // pas d'ancien coach
		  if (getCoach() == null && c != null){
		    this.coach = c;
		    c.setTeam(this);
		  }
		  else if (getCoach() != null && c == null){
		    getCoach().setTeam(null);
		    this.coach = c;
		  }
		  else if (getCoach() != null && c != null){
		    if (!(getCoach().equals(c))){
		      getCoach().setTeam(null);
		      c.setTeam(this);
		      this.coach = c;
		    }
		  }
	}
	
	public void addPlayer(Player p){
		if (p.getTeam() != null)
			p.getTeam().getPlayers().remove(p);
		p.setTeam(this);
		this.getPlayers().add(p);
		// vous pouvez encore amliorer ce code et le rendre plus robuste
		// avec des exceptions applicatives par exemple
	}

}
