package ch8.demoUserType;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class ScoreUserType implements UserType {
	public int[] sqlTypes() {
		return new int[] { Hibernate.STRING.sqlType() };
	}

	public Class returnedClass() {
		return Score.class;
	}

	public boolean isMutable() {
		return false;
	}

	public Object deepCopy(Object value) {
		Score score = (Score) value;
		Score copy = new Score();
		copy.setAwayTeamScore(score.getAwayTeamScore());
		copy.setHomeTeamScore(score.getHomeTeamScore());
		return copy;
	}

	public Serializable disassemble(Object value) {
		// attention implmenter cette mthode est plus compliqu que cela
		return (Serializable) value;
	}

	public Object assemble(Serializable cached, Object owner) {
		// attention implmenter cette mthode est plus compliqu que cela
		return cached;
	}

	public Object replace(Object original, Object target, Object owner) {
		Score copy = new Score();
		Score source = (Score)original;
		copy.setAwayTeamScore(source.getAwayTeamScore());
		copy.setHomeTeamScore(source.getHomeTeamScore());
		return copy;
	}

	public boolean equals(Object x, Object y) {
		if (x == y)
			return true;
		if (x == null || y == null)
			return false;
		return x.equals(y);
	}

	public int hashCode(Object x) {
		return x.hashCode();
	}

	public Object nullSafeGet(ResultSet resultSet, String[] names, Object owner)
			throws SQLException {
		String stringValue = resultSet.getString(names[0]);
		if (resultSet.wasNull())
			return null;
		String[] scores = stringValue.split("-");
		int homeValue = Integer.parseInt(scores[0].trim());
		int awayValue = Integer.parseInt(scores[1].trim());
		
		Score score = new Score();
		score.setAwayTeamScore(awayValue);
		score.setHomeTeamScore(homeValue);
		
		return score;
	}

	public void nullSafeSet(PreparedStatement statement, Object value, int index)
			throws HibernateException, SQLException {
		if (value == null) {
			statement.setNull(index, Hibernate.BIG_DECIMAL.sqlType());
		} else {
			Score score = (Score) value;
			statement.setString(index, score.getHomeTeamScore() + " - " + score.getAwayTeamScore());
		}
	}
}