package ch10Tests;

import java.util.List;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.stat.Statistics;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch10.Coach;
import ch10.Game;
import ch10.Player;
import ch10.Team;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch10CacheTestCase extends BaseTestCase
{
	public Ch10CacheTestCase()
	{
		super("Ch10CacheTestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch10CacheTestCase.jar");

		jar.addClass(Team.class);
		jar.addClass(Coach.class);
		jar.addClass(Player.class);
		jar.addClass(Game.class);
		jar.addResource("myDS-ds.xml");
		//jar.addResource("ehcache.xml");
		jar.addResource("treecache.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch10CacheTestCase.class);
	}


	public void initDatas() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Team team = new Team();
		team.setName("xxxxxx");
		Player p1 = new Player();
		p1.setName("p1");
		team.getPlayers().add(p1);
		p1.setTeam(team);
		
		Player p2 = new Player();
		p2.setName("p2");
		team.getPlayers().add(p2);
		p2.setTeam(team);
		
		em.persist(p1);
		em.persist(p2);
		em.persist(team);
		tm.commit();
	}
	
	public void load() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Team team = em.find(Team.class, new Integer(1));
		tm.commit();
	}
	
	public void testCache() throws Exception
	{
		initDatas();
		load();
		//mettre point d'arrt, vrifier qu'aucune requte n'est gnre
		// ce qui signifie que l'entit est assemble depuis le cache
		// et non depuis la base de donnes.
		load();
	}

	public void testCache2() throws Exception
	{
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Team team = em.find(Team.class, new Integer(1));
		team.setName("new name");
		tm.commit();
		em.clear();
		
		tm.begin();
		Team team2 = em.find(Team.class, new Integer(1));
		tm.commit();
	
	}

	public void testStatistics() throws Exception
	{
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		SessionFactory sf = (SessionFactory) new InitialContext().lookup("java:/HibernateSessionFactory");
		Statistics stats = sf.getStatistics();
		
		tm.begin();
		Team team = em.find(Team.class, new Integer(1));
		tm.commit();
		em.clear();
		
		tm.begin();
		Team team2 = em.find(Team.class, new Integer(1));
		tm.commit();
	}

	public void testCacheMode() throws Exception
	{
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		Session session = (Session)em.getDelegate();
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		session.setCacheMode(CacheMode.GET);
		Team team = (Team)session.get(Team.class, new Integer(1));
		tm.commit();
		em.clear();
		
		tm.begin();
		Team team2 = (Team)session.get(Team.class, new Integer(1));
		tm.commit();
	
	}
	
	public void testSimpleNamedNativeQuery() throws Exception {
		initDatas();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");
	
		tm.begin();
		Team team = em.find(Team.class, new Integer(1));
		
		Query query = em.createNamedQuery("myNamedQuery");
		query.setParameter("param","xxxxxx");
		List result = query.getResultList();
		
		//excution de la mme requte
		List result2 = query.getResultList();
		
		tm.commit();
	}


}
