package ch10Tests;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch10.Coach;
import ch10.Game;
import ch10.Player;
import ch10.Team;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch10ValidatorTestCase extends BaseTestCase
{
	public Ch10ValidatorTestCase()
	{
		super("Ch10ValidatorTestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch10ValidatorTestCase.jar");

		jar.addClass(Team.class);
		jar.addClass(Coach.class);
		jar.addClass(Player.class);
		jar.addClass(Game.class);
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch10ValidatorTestCase.class);
	}


	public void applicativeValidatorTest() throws Exception
	{
		Coach coach = new Coach();
		coach.setName("xxxxxx");
		
		ClassValidator coachValidator = new ClassValidator( Coach.class );
		//ClassValidator addressValidator = new ClassValidator( Address.class, ResourceBundle.getBundle("messages", Locale.ENGLISH) );

		InvalidValue[] validationMessages = coachValidator.getInvalidValues(coach);
		
	}
	
	public void javaPersistenceValidatorTest() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Player p = new Player();
		p.setName("Xxxx");
		em.persist(p);
		tm.commit();

		
	}


}
