package ch3Tests;

import java.util.Date;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch3.Coach;
import ch3.Game;
import ch3.Player;
import ch3.Team;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch3TestCase extends BaseTestCase
{
	public Ch3TestCase()
   {
      super("Ch3TestCase");
   }

   private static AssembledDirectory jar;


   
   //public static void deploy()
   public static void deploy()
   {
      jar = AssembledContextFactory.getInstance().create("Ch3TestCase.jar");

      jar.addClass(Team.class);
      jar.addClass(Coach.class);
      jar.addClass(Player.class);
      jar.addClass(Game.class);
      jar.addResource("myDS-ds.xml");
      jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");
      try
      {
         Bootstrap.getInstance().deploy(jar);
      }
      catch (DeploymentException e)
      {
         throw new RuntimeException("Unable to deploy", e);
      }
   }

   public static void undeploy()
   {
      try
      {
         Bootstrap.getInstance().undeploy(jar);
         AssembledContextFactory.getInstance().remove(jar);
         jar = null;
      }
      catch (DeploymentException e)
      {
         throw new RuntimeException("Unable to undeploy", e);
      }
   }



   public static Test suite()
   {
      return preProcessedTest(Ch3TestCase.class);
   }

   public void testEntityManager() throws Exception
   {
      EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

      // Obtain JBoss transaction
      TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

      tm.begin();
      
      Team om = new Team();
      om.setName("om");
      Coach omCoach = new Coach();
      omCoach.setName("omCoach");
      em.persist(om);
      em.persist(omCoach);
      Player cisse = new Player();
      cisse.setName("cisse");
      em.persist(cisse);
      
      om.setCoach(omCoach);
      om.getPlayers().add(cisse);
      cisse.setTeam(om);
      
      Team psg = new Team();
      psg.setName("psg");
      Coach psgCoach = new Coach();
      psgCoach.setName("psgCoach");
      em.persist(psg);
      em.persist(psgCoach);
      Player rothen = new Player();
      rothen.setName("rothen");
      em.persist(rothen);
      
      psg.setCoach(psgCoach);
      psg.getPlayers().add(rothen);
      rothen.setTeam(psg);
      
      Game omPsg = new Game();
      omPsg.setGameDate(new Date());
      omPsg.setHomeTeam(om);
      omPsg.setAwayTeam(psg);
      omPsg.setMostValuablePlayer(cisse);
      
      em.persist(omPsg);
 
      //assertTrue(team.getId() > 0);

      //int id = team.getId();

      //System.out.println("created team in DB with id: " + id);

      tm.commit();

//      tm.begin();
//      team = new Team();
//      team.setId(1);
//      em.persist(team);
//      team = em.find(Team.class, id);
//      assertNotNull(team);
//      tm.commit();
   }
}
