package ch4Tests.demoNaire;

import java.util.Date;
import java.util.List;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch4.demoNaire.Coach;
import ch4.demoNaire.CoachTeam;
import ch4.demoNaire.Person;
import ch4.demoNaire.Season;
import ch4.demoNaire.Team;





public class Ch4TestCase extends BaseTestCase
{
	public Ch4TestCase()
	{
		super("Ch3TestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch3TestCase.jar");

		jar.addClass(Coach.class);
		jar.addClass(Person.class);
		jar.addClass(Team.class);
		jar.addClass(Season.class);
		jar.addClass(CoachTeam.class);
		
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch4TestCase.class);
	}

	public void test() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
		
		tm.begin();
		Query q = em.createQuery("from Coach");
		List results = q.getResultList();
		
		tm.commit();
		
		
		Team team = new Team();
		team.setName("OM");
		Coach coach = new Coach();
		coach.setName("coach");
		Season s = new Season();
		s.setStartDate(new Date());
		s.setEndDate(new Date());
		
		Person director = new Person();
		director.setName("the diretor");
		CoachTeam coachTeam = new CoachTeam();
		coachTeam.setCoach(coach);
		coachTeam.setDirector(director);
		coach.getCoachTeams().put(s, coachTeam);
		tm.begin();
		em.persist(director);   
		em.persist(s);   
 		em.persist(team);   
		em.persist(coach);  
		tm.commit();




	}
}
