package ch4Tests.demoOneToOne;

import java.util.List;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch4.demoOneToOne.Coach;
import ch4.demoOneToOne.Game;
import ch4.demoOneToOne.Player;
import ch4.demoOneToOne.Team;





public class Ch4TestCase extends BaseTestCase
{
	public Ch4TestCase()
	{
		super("Ch3TestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch3TestCase.jar");

		jar.addClass(Coach.class);
		jar.addClass(Player.class);
		jar.addClass(Team.class);
		jar.addClass(Game.class);
		
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch4TestCase.class);
	}

	public void test() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		Team team = new Team();
		team.setName("OM");
		Coach coach = new Coach();
		coach.setName("coach");
		team.setCoach(coach);
		coach.setTeam(team);
		tm.begin();
 		em.persist(team);   
		em.persist(coach);  
		tm.commit();
		



		//om.getPlayers().add(cisse);


		tm.begin();
		Player cisse = new Player();
		cisse.setName("cisse");
		Team om = (Team)em.find(Team.class, new Integer(1));
		cisse.setTeam(om);
		om.getPlayers().add(cisse);
		em.persist(cisse);
		tm.commit();

		tm.begin();
		List players = em.createQuery("select p from Player p").getResultList();     
		tm.commit();

	}
}
