package ch4Tests.heritage;

import java.util.ArrayList;
import java.util.List;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;





public class Ch4TestCase extends BaseTestCase
{
	public Ch4TestCase()
	{
		super("Ch3TestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch3TestCase.jar");

		jar.addClass(ch4.parClasseConcrete.Person.class);
		jar.addClass(ch4.parClasseConcrete.Coach.class);
		jar.addClass(ch4.parClasseConcrete.Player.class);
		jar.addClass(ch4.parClasseConcrete.Team.class);
		jar.addClass(ch4.parSousClasse.Person.class);
		jar.addClass(ch4.parSousClasse.Coach.class);
		jar.addClass(ch4.parSousClasse.Player.class);
		jar.addClass(ch4.parSousClasse.Team.class);
		jar.addClass(ch4.parSousClasseDiscriminateur.Person.class);
		jar.addClass(ch4.parSousClasseDiscriminateur.Coach.class);
		jar.addClass(ch4.parSousClasseDiscriminateur.Player.class);
		jar.addClass(ch4.parSousClasseDiscriminateur.Team.class);
		jar.addClass(ch4.parClasseConcreteUnion.Person.class);
		jar.addClass(ch4.parClasseConcreteUnion.Coach.class);
		jar.addClass(ch4.parClasseConcreteUnion.Player.class);
		jar.addClass(ch4.parClasseConcreteUnion.Team.class);
		jar.addClass(ch4.parHierarchie.Person.class);
		jar.addClass(ch4.parHierarchie.Coach.class);
		jar.addClass(ch4.parHierarchie.Player.class);
		jar.addClass(ch4.parHierarchie.SuperStar.class);
		jar.addClass(ch4.parHierarchie.Rookie.class);
		jar.addClass(ch4.parHierarchie.Team.class);
		jar.addClass(ch4.parHierarchie.School.class);
		jar.addClass(ch4.parHierarchie.Sponsor.class);

		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch4TestCase.class);
	}

	public void testParClasseConcrete() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		ch4.parClasseConcrete.Player cisse = new ch4.parClasseConcrete.Player();
		cisse.setName("cisse");
		cisse.setNumber(12);

		ch4.parClasseConcrete.Coach wenger = new ch4.parClasseConcrete.Coach();
		wenger.setName("wenger");
		wenger.setCoachedTeamName("arsenal");

		tm.begin();
		em.persist(cisse);
		em.persist(wenger);      
		tm.commit();

		tm.begin();
		List persons = em.createQuery("select person from ch4.parClasseConcrete.Person person").getResultList();     
		tm.commit();

	}
	public void testParClasseConcreteUnion() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
	
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		ch4.parClasseConcreteUnion.Player cisse = new ch4.parClasseConcreteUnion.Player();
		cisse.setName("cisse");
		cisse.setNumber(12);
		cisse.setId(new Long(1));
	
		ch4.parClasseConcreteUnion.Coach wenger = new ch4.parClasseConcreteUnion.Coach();
		wenger.setName("wenger");
		wenger.setCoachedTeamName("arsenal");
		wenger.setId(new Long(2));
	
		tm.begin();
		em.persist(cisse);
		em.persist(wenger);      
		tm.commit();
	
		tm.begin();
		//List persons = em.createQuery("select person from ch4.parClasseConcreteUnion.Person person").getResultList();
		ch4.parClasseConcreteUnion.Person p = (ch4.parClasseConcreteUnion.Person)em.find(ch4.parClasseConcreteUnion.Person.class, new Long(1));
		tm.commit();
	
	}

	public void testParSousClasse() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
	
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		ch4.parSousClasse.Player cisse = new ch4.parSousClasse.Player();
		cisse.setName("cisse");
		cisse.setNumber(12);
	
		ch4.parSousClasse.Coach wenger = new ch4.parSousClasse.Coach();
		wenger.setName("wenger");
		wenger.setCoachedTeamName("arsenal");
	
	
		tm.begin();
		em.persist(cisse);
		em.persist(wenger);      
		tm.commit();
	
		tm.begin();
		List persons = em.createQuery("select person from ch4.parSousClasse.Person person").getResultList();
		//ch4.parSousClasse.Person p = (ch4.parSousClasse.Person)em.find(ch4.parSousClasse.Person.class, new Long(1));
		tm.commit();
	
	}

	public void testParSousClasseDiscrim() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		ch4.parSousClasseDiscriminateur.Player cisse = new ch4.parSousClasseDiscriminateur.Player();
		cisse.setName("cisse");
		cisse.setNumber(12);

		ch4.parSousClasseDiscriminateur.Coach wenger = new ch4.parSousClasseDiscriminateur.Coach();
		wenger.setName("wenger");
		wenger.setCoachedTeamName("arsenal");


		tm.begin();
		em.persist(cisse);
		em.persist(wenger);      
		tm.commit();

		tm.begin();
		List persons = em.createQuery("select person from ch4.parSousClasseDiscriminateur.Person person").getResultList();
		//ch4.parSousClasse.Person p = (ch4.parSousClasse.Person)em.find(ch4.parSousClasse.Person.class, new Long(1));
		tm.commit();

	}

	public void testParHierarchie() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		ch4.parHierarchie.Player cisse = new ch4.parHierarchie.SuperStar();
		cisse.setName("cisse");
		cisse.setNumber(12);
		
		ch4.parHierarchie.Coach wenger = new ch4.parHierarchie.Coach();
		wenger.setName("wenger");
		wenger.setCoachedTeamName("arsenal");
		
		tm.begin();
		em.persist(cisse);
		em.persist(wenger);      
		tm.commit();

		tm.begin();
		List ids = new ArrayList();
		ids.add(new Long(1));
		ids.add(new Long(2));
		List persons = em.createQuery("select player from ch4.parHierarchie.Player player where player.id in (:ids)")
		.setParameter("ids", ids)
		.getResultList();
		//ch4.parHierarchie.Person p = (ch4.parHierarchie.Person)em.find(ch4.parHierarchie.Person.class, new Long(1));
		tm.commit();

	}
}
