package ch5Tests;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.hibernate.Session;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch5.Characteristic;
import ch5.Coach;
import ch5.Game;
import ch5.Player;
import ch5.School;
import ch5.Team;

/**
 * Comment
 * 
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch5EjbQlTestCase extends BaseTestCase {
	public Ch5EjbQlTestCase() {
		super("Ch5HqlTestCase");
	}

	private static AssembledDirectory jar;

	// public static void deploy()
	public static void deploy() {
		jar = AssembledContextFactory.getInstance().create("Ch5HqlTestCase.jar");

		jar.addClass(Team.class);
		jar.addClass(Coach.class);
		jar.addClass(Player.class);
		jar.addClass(School.class);
		jar.addClass(Game.class);
		jar.addClass(Characteristic.class);
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml",
		"persistence.xml");

		try {
			Bootstrap.getInstance().deploy(jar);
		} catch (DeploymentException e) {
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy() {
		try {
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		} catch (DeploymentException e) {
			throw new RuntimeException("Unable to undeploy", e);
		}
	}

	public static Test suite() {
		return preProcessedTest(Ch5EjbQlTestCase.class);
	}

	//pour charger la base de donnes
	public void initData() throws Exception {
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");

		tm.begin();

		Team teamA = new Team("Team A");
		Team teamB = new Team("Team B");

		Characteristic c1 = new Characteristic();
		Characteristic c2 = new Characteristic();
		Characteristic c3 = new Characteristic();
		Characteristic c4 = new Characteristic();
		Characteristic c5 = new Characteristic();
		Characteristic c6 = new Characteristic();
		Characteristic c7 = new Characteristic();
		Characteristic c8 = new Characteristic();
		Characteristic c9 = new Characteristic();
		Characteristic c10 = new Characteristic();
		Characteristic c11 = new Characteristic();
		Characteristic c12 = new Characteristic();
		Characteristic c13 = new Characteristic();
		Characteristic c14 = new Characteristic();
		Characteristic c15 = new Characteristic();

		Player pa1 = new Player("pl1");
		pa1.getCharacteristics().add(c1);
		pa1.getCharacteristics().add(c2);
		Player pa2 = new Player("pl2");
		pa2.getCharacteristics().add(c3);
		pa2.getCharacteristics().add(c4);
		pa2.getCharacteristics().add(c5);
		Player pa3 = new Player("pl3");
		pa3.getCharacteristics().add(c6);
		pa3.getCharacteristics().add(c7);
		Player pa4 = new Player("pl4");
		pa4.getCharacteristics().add(c8);
		pa4.getCharacteristics().add(c9);
		pa4.getCharacteristics().add(c10);
		pa4.getCharacteristics().add(c11);
		pa4.getCharacteristics().add(c12);
		Player pa5 = new Player("pl5");
		pa5.getCharacteristics().add(c13);
		pa5.getCharacteristics().add(c14);
		pa5.getCharacteristics().add(c15);

		teamA.getPlayers().add(pa1);
		pa1.setTeam(teamA);
		teamA.getPlayers().add(pa2);
		pa2.setTeam(teamA);
		teamA.getPlayers().add(pa3);
		pa3.setTeam(teamA);
		teamA.getPlayers().add(pa4);
		pa4.setTeam(teamA);
		teamB.getPlayers().add(pa5);
		pa5.setTeam(teamB);

		em.persist(teamA);
		em.persist(teamB);

		tm.commit();
	}

	// modifiez ce test pour mettre en vidence votre paramtrage lazy
	public void testLazyToMany() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");

		tm.begin();
		Team team = (Team) em.find(Team.class, new Integer(1));
		System.out.println(((Player) team.getPlayers().iterator().next())
				.getName());

		tm.commit();
	}

	// permet de mettre en vidence les perfs selon le type de collection choisi
	public void testAddInCollection() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");
	
		tm.begin();
		Team team = (Team) em.find(Team.class, new Integer(1));
		Player p = new Player("the new player");
		team.getPlayers().add(p);
		p.setTeam(team);
		tm.commit();
	}

	// permet de mettre en vidence les perfs selon le type de collection choisi
	public void testUpdateInCollection() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");

		tm.begin();
		Team team = (Team) em.find(Team.class, new Integer(1));
		Player p = team.getPlayers().iterator().next();
		p.setName("newname");
		tm.commit();
	}

	// tester le comportement lazy des association toOne
	public void testLazyToOne() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");

		tm.begin();
		Player player = (Player) em.find(Player.class, new Integer(1));
		System.out.println(player.getTeam().getName());

		tm.commit();
	}

	// modifiez ce test  souhait pour tester vos requtes EJB-QL
		public void testEjbQl() throws Exception {
			initData();
			EntityManager em = (EntityManager) new InitialContext()
			.lookup("java:/EntityManagers/eyrollesEntityManager");
	
			// Obtain JBoss transaction
			TransactionManager tm = (TransactionManager) new InitialContext()
			.lookup("java:/TransactionManager");
	
			tm.begin();
			StringBuffer queryString = new StringBuffer();
			queryString.append("Select player from Player player ")
			.append("where player.name in(:name1) ");
			Query query = em.createQuery(queryString.toString());
			List parameterList = new ArrayList();
			parameterList.add("toto");
			parameterList.add("titi");
			query.setParameter("name1",parameterList);
			List result = query.getResultList();
	
	//		Player player = (Player) em.createQuery("select player from player")
	//		.setParameter(1, "blah")
	//		.getResultList().get(0);
	//		System.out.println(player.getTeam().getName());
	
			tm.commit();
		}

		// modifiez ce test  souhait pour tester vos requtes EJB-QL
			public void testNamedQuery() throws Exception {
				initData();
				EntityManager em = (EntityManager) new InitialContext()
				.lookup("java:/EntityManagers/eyrollesEntityManager");
		
				// Obtain JBoss transaction
				TransactionManager tm = (TransactionManager) new InitialContext()
				.lookup("java:/TransactionManager");
		
				tm.begin();
				Query query = em.createNamedQuery("myNamedQuery");
				List parameterList = new ArrayList();
				parameterList.add("toto");
				parameterList.add("titi");
				query.setParameter("name1",parameterList);
				List result = query.getResultList();
		
		//		Player player = (Player) em.createQuery("select player from player")
		//		.setParameter(1, "blah")
		//		.getResultList().get(0);
		//		System.out.println(player.getTeam().getName());
		
				tm.commit();
			}

	// modifiez ce test  souhait pour tester vos requtes EJB-QL
				public void testGroupQuery() throws Exception {
					initData();
					EntityManager em = (EntityManager) new InitialContext()
					.lookup("java:/EntityManagers/eyrollesEntityManager");
			
					// Obtain JBoss transaction
					TransactionManager tm = (TransactionManager) new InitialContext()
					.lookup("java:/TransactionManager");
			
					tm.begin();
					StringBuffer queryString = new StringBuffer();
					queryString.append("Select avg(player.height) ")
					  .append("from Team team join team.players player ")
					  .append("group by team ")
					  .append("having count(player) >5");
					Query query = em.createQuery(queryString.toString());
			
					List result = query.getResultList();
			
			
			//		Player player = (Player) em.createQuery("select player from player")
			//		.setParameter(1, "blah")
			//		.getResultList().get(0);
			//		System.out.println(player.getTeam().getName());
			
					tm.commit();
				}

	// modifiez ce test  souhait pour tester vos requtes EJB-QL
					public void testSubSelectQuery() throws Exception {
						initData();
						EntityManager em = (EntityManager) new InitialContext()
						.lookup("java:/EntityManagers/eyrollesEntityManager");
				
						// Obtain JBoss transaction
						TransactionManager tm = (TransactionManager) new InitialContext()
						.lookup("java:/TransactionManager");
				
						tm.begin();
						StringBuffer queryString = new StringBuffer();
						queryString.append("from Team team ")
						  .append("where :height = ")
						  .append(" (select max(player.height) from team.players player)");
						Query query = em.createQuery(queryString.toString());
						query.setParameter("height", new Float(1.80));
				
						List result = query.getResultList();
				
				
				//		Player player = (Player) em.createQuery("select player from player")
				//		.setParameter(1, "blah")
				//		.getResultList().get(0);
				//		System.out.println(player.getTeam().getName());
				
						tm.commit();
					}

	// modifiez ce test  souhait pour tester vos requtes EJB-QL
	public void testPagination() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");

		tm.begin();
		Query query = em.createQuery("from Team team");
		query.setFirstResult(10)
		  .setMaxResults(20);
		List result = query.getResultList();


//		Player player = (Player) em.createQuery("select player from player")
//		.setParameter(1, "blah")
//		.getResultList().get(0);
//		System.out.println(player.getTeam().getName());

		tm.commit();
	}

	// un moyen facile de tester les fonctions natives de la session hibernate
	public void getHibernateSession() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");

		tm.begin();
		Session session = (Session)em.getDelegate();
		Player player = (Player) session.createQuery("select player from player")
		.setProperties("blah")
		.list().get(0);
		tm.commit();
	}


	// analysez les logs pour la situation la plus dlicate, 2 collections en parallele
	public void testCollectionParalleles() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");

		tm.begin();
		StringBuffer queryString = new StringBuffer();
		queryString.append("select team from Team team ")
		.append("left join fetch team.players p where p.name='pl1'");
		Set results = new HashSet(em.createQuery(queryString.toString()).getResultList());
		Iterator itTeam = results.iterator();
		while (itTeam.hasNext()){
			Team team = (Team)itTeam.next();
			Iterator itPlayer = team.getPlayers().iterator();
			while (itPlayer.hasNext()){
				Player player = (Player)itPlayer.next();
				Iterator itCharacteristic = player.getCharacteristics().iterator();
				while (itCharacteristic.hasNext()){
					Characteristic characteristic = 
						(Characteristic)itCharacteristic.next();
					String test = characteristic.getName();
				}
			}
		}
		tm.commit();
	}

}
