package ch5Tests;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.hibernate.Session;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch5.Characteristic;
import ch5.Coach;
import ch5.Game;
import ch5.Player;
import ch5.School;
import ch5.Team;

/**
 * Comment
 * 
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch5NativeQueryTestCase extends BaseTestCase {
	public Ch5NativeQueryTestCase() {
		super("Ch5HqlTestCase");
	}

	private static AssembledDirectory jar;

	// public static void deploy()
	public static void deploy() {
		jar = AssembledContextFactory.getInstance().create("Ch5HqlTestCase.jar");

		jar.addClass(Team.class);
		jar.addClass(Coach.class);
		jar.addClass(Player.class);
		jar.addClass(Game.class);
		jar.addClass(School.class);
		jar.addClass(Characteristic.class);
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml",
		"persistence.xml");

		try {
			Bootstrap.getInstance().deploy(jar);
		} catch (DeploymentException e) {
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy() {
		try {
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		} catch (DeploymentException e) {
			throw new RuntimeException("Unable to undeploy", e);
		}
	}

	public static Test suite() {
		return preProcessedTest(Ch5NativeQueryTestCase.class);
	}

	//pour charger la base de donnes
	//pour charger la base de donnes
	public void initData() throws Exception {
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");

		tm.begin();

        Team teamA = new Team("Team A");
        Team teamB = new Team("Team B");
        Coach coachA = new Coach("coachA");
        Coach coachB = new Coach("coachB");
        teamA.setCoach(coachA);
        //teamB.setCoach(coachB);
        
        Player pa1 = new Player("pa1");
        Player pa2 = new Player("pa2");
        Player pa3 = new Player("pa3");
        Player pa4 = new Player("pa4");
        Player pa5 = new Player("pa5");
        Player pa6 = new Player("pa6");
        Player pa7 = new Player("pa7");
        Player pa8 = new Player("pa8");
        Player pa9 = new Player("pa9");
        Player pa10 = new Player("pa10");
        
        School sc1 = new School("sc1");
        School sc2 = new School("sc2");
        School sc3 = new School("sc3");
        School sc4 = new School("sc4");
        School sc5 = new School("sc5");
        School sc6 = new School("sc6");
        School sc7 = new School("sc7");
        School sc8 = new School("sc8");
        School sc9 = new School("sc9");
        School sc10 = new School("sc10");
        
        pa1.setSchool(sc1);
        pa2.setSchool(sc2);
        pa3.setSchool(sc3);
        pa4.setSchool(sc4);
        pa5.setSchool(sc5);
        pa6.setSchool(sc6);
        pa7.setSchool(sc7);
        pa8.setSchool(sc8);
        pa9.setSchool(sc9);
        pa10.setSchool(sc10);
        
        teamA.getPlayers().add(pa1);
        teamA.getPlayers().add(pa2);
        teamA.getPlayers().add(pa3);
        teamA.getPlayers().add(pa4);
        teamA.getPlayers().add(pa5);
        teamA.getPlayers().add(pa6);
        teamA.getPlayers().add(pa7);
        teamA.getPlayers().add(pa8);
        teamA.getPlayers().add(pa9);
        teamA.getPlayers().add(pa10);
        
        
        Player pb1 = new Player("pb1");
        Player pb2 = new Player("pb2");
        Player pb3 = new Player("pb3");
        Player pb4 = new Player("pb4");
        Player pb5 = new Player("pb5");
        Player pb6 = new Player("pb6");
        Player pb7 = new Player("pb7");
        Player pb8 = new Player("pb8");
        Player pb9 = new Player("pb9");
        Player pb10 = new Player("pb10");
        
        pb1.setSchool(sc1);
        pb2.setSchool(sc2);
        pb3.setSchool(sc3);
        pb4.setSchool(sc4);
        pb5.setSchool(sc5);
        pb6.setSchool(sc6);
        pb7.setSchool(sc7);
        pb8.setSchool(sc8);
        pb9.setSchool(sc9);
        pb10.setSchool(sc10);
        
        teamB.getPlayers().add(pb1);
        teamB.getPlayers().add(pb2);
        teamB.getPlayers().add(pb3);
        teamB.getPlayers().add(pb4);
        teamB.getPlayers().add(pb5);
        teamB.getPlayers().add(pb6);
        teamB.getPlayers().add(pb7);
        teamB.getPlayers().add(pb8);
        teamB.getPlayers().add(pb9);
        teamB.getPlayers().add(pb10);
		em.persist(teamA);
		em.persist(teamB);

		tm.commit();
	}

	// requte native de base
	public void testSimpleNativeQuery() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");
	
		tm.begin();
		StringBuffer queryString = new StringBuffer();
		//queryString.append("Select player.id, player.name, player.height, player.school_id ")
		queryString.append("Select player.* ")
			.append("from Player player, School school ")
			.append("where player.school_id = school.id ")
			.append("and school.name = :param");
		Query query = em.createNativeQuery(queryString.toString(),Player.class);
		query.setParameter("param","sc1");
		List result = query.getResultList();
	
		tm.commit();
	}
	
	// requte native de base
	public void testSimpleNamedNativeQuery() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");
	
		tm.begin();
		Query query = em.createNamedQuery("myNamedQuery");
		query.setParameter("name1","sc1");
		List result = query.getResultList();
	
		tm.commit();
	}

	// utilisation du mapping de resultset de base
	public void testSimpleResultSetMapping() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");

		tm.begin();
		StringBuffer queryString = new StringBuffer();
		//queryString.append("Select player.id, player.name, player.height, player.school_id ")
		queryString.append("Select player.* ")
			.append("from Player player, School school ")
			.append("where player.school_id = school.id ")
			.append("and school.name = :param");
		Query query = em.createNativeQuery(queryString.toString(),"PlayerResults");
		query.setParameter("param","sc1");
		List result = query.getResultList();

		tm.commit();
	}
	
	// utilisation du mapping de resultset de base
	public void testLinkedResultSetMapping() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");

		tm.begin();
		StringBuffer queryString = new StringBuffer();
		queryString.append("Select player.*, school.id school_id, school.name school_name ")
			.append("from Player player, School school ")
			.append("where player.school_id = school.id ")
			.append("and school.name = :param");
		Query query = em.createNativeQuery(queryString.toString(),"PlayerWithSchoolResults");
		query.setParameter("param","sc1");
		List result = query.getResultList();

		tm.commit();
	}
	
	
	public void testResultSetValue() throws Exception {
		initData();
		EntityManager em = (EntityManager) new InitialContext()
		.lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext()
		.lookup("java:/TransactionManager");

		tm.begin();
		StringBuffer queryString = new StringBuffer();
		queryString.append("Select max(school.id) as maxid ")
			.append("from School school ");
			
		Query query = em.createNativeQuery(queryString.toString(),"MaxSchoolId");
		List result = query.getResultList();

		tm.commit();
	}

}
