package ch6Tests;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.hibernate.LockMode;
import org.hibernate.Session;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch6.Coach;
import ch6.Player;
import ch6.School;
import ch6.Team;


/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch6TestCase extends BaseTestCase
{
	public Ch6TestCase()
	{
		super("Ch6TestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch6TestCase.jar");

		jar.addClass(Team.class);
		jar.addClass(Coach.class);
		jar.addClass(Player.class);
		jar.addClass(School.class);
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch6TestCase.class);
	}

	public void testPersist() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
	
		Team team = new Team("cascade test team");
		Player player = new Player ("cascade player test");
		School school = new School ("cascade school test");
		Coach coach= new Coach ("cascade test coach");
		player.setSchool(school);
		team.getPlayers().add(player);
		team.setCoach(coach);
		em.persist(team);
		// si cascade activ, les 3 lignes suivantes sont inutiles
		//em.persist(coach);
		//em.persist(school);
		//em.persist(player);	        
	
		tm.commit();
	
		tm.begin();
	
		em.merge(coach);
	
		tm.commit();
	
	}

	public void testSimpleRemove() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Team team = new Team("cascade test team");
		Player player = new Player ("cascade player test");
		School school = new School ("cascade school test");
		Coach coach= new Coach ("cascade test coach");
		player.setSchool(school);
		team.getPlayers().add(player);
		team.setCoach(coach);
		em.persist(team);
		tm.commit();
	
		tm.begin();
		Team t = em.find(Team.class, new Integer(1));
		em.remove(t);
		tm.commit();
	
	}

	public void testDeleteOrphan() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Team team = new Team("cascade test team");
		Player player = new Player ("cascade player test");
		Player player2 = new Player ("cascade player2 test");
		School school = new School ("cascade school test");
		Coach coach= new Coach ("cascade test coach");
		player.setSchool(school);
		player2.setSchool(school);
		team.getPlayers().add(player);
		player.setTeam(team);
		team.getPlayers().add(player2);
		player2.setTeam(team);
		team.setCoach(coach);
		em.persist(team);
		tm.commit();
	
		tm.begin();
		Team t = em.find(Team.class, new Integer(1));
		Player p =  t.getPlayers().iterator().next();
		Player p2 =  t.getPlayers().iterator().next();
		t.getPlayers().remove(p);
		t.getPlayers().remove(p2);
		p.setTeam(null);
		p2.setTeam(null);
		tm.commit();
	
	}

	public void testMovingCollection() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();
		Team teamA = new Team("cascade test team");
		Team teamB = new Team("cascade test team");
		Player player = new Player ("cascade player test");
		School school = new School ("cascade school test");
		Coach coach= new Coach ("cascade test coach");
		player.setSchool(school);
		teamA.getPlayers().add(player);
		teamA.setCoach(coach);
		em.persist(teamA);
		em.persist(teamB);
		tm.commit();

		tm.begin();
		Team team1 = (Team)em.find(Team.class,new Integer(1));		    
		Team team2 = (Team)em.find(Team.class,new Integer(2));
		Player p = (Player)team1.getPlayers().iterator().next();
		team1.getPlayers().remove(p);
		team2.getPlayers().add(p);
		tm.commit();

	}

	public void testMerge() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();
		Coach coach= new Coach ("test coach");
		em.persist(coach);
		tm.commit();
		// instance dtache

		coach.setName("new name");

		tm.begin();
		Coach attachedCoach = em.merge(coach);
		assertTrue(em.contains(attachedCoach));
		assertFalse(em.contains(coach));
		tm.commit();

	}

	public void testHibernateUpdate() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();
		Coach coach= new Coach ("test coach");
		em.persist(coach);
		tm.commit();
		// instance dtache

		coach.setName("new name");

		tm.begin();
		Session session = (Session)em.getDelegate();
		session.update(coach);
		assertTrue(session.contains(coach));
		tm.commit();

	}

	public void testHibernateLock() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Coach coach= new Coach ("test coach");
		em.persist(coach);
		tm.commit();
		// instance dtache
	
		coach.setName("new name");
	
		tm.begin();
		Session session = (Session)em.getDelegate();
		session.lock(coach, LockMode.NONE);
		assertTrue(session.contains(coach));
		tm.commit();
	
	}
}
