package ch7Tests;

import java.util.List;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch7.model.Coach;
import ch7.model.Game;
import ch7.model.Player;
import ch7.model.Team;
import ch7.service.ConversationDemo;
import ch7.service.ConversationDemoDetached;
import ch7.service.ConversationDemoExtended;
import ch7.service.TeamManager;
import ch7.service.TeamManagerBeanBmt;
import ch7.service.TeamManagerBeanCmt;



/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch7TestCase extends BaseTestCase
{
	public Ch7TestCase()
	{
		super("Ch7TestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch7TestCase.jar");

		jar.addClass(Team.class);
		jar.addClass(Coach.class);
		jar.addClass(Player.class);
		jar.addClass(Game.class);
		jar.addClass(TeamManager.class);
		jar.addClass(ConversationDemoDetached.class);
		jar.addClass(ConversationDemoExtended.class);
		jar.addClass(ConversationDemo.class);
		jar.addClass(TeamManagerBeanBmt.class);
		jar.addClass(TeamManagerBeanCmt.class);
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch7TestCase.class);
	}


	public void testMinimal() throws Exception
	{
		EntityManager em = null;
	
		// Obtain JBoss transaction
		TransactionManager tm = null;
	
		try{
			em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
			tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
			tm.begin();
			Team team = new Team("cascade test team");
			Player player = new Player();
			player.setName("cascade player test");
			Coach coach= new Coach ();
			coach.setName("cascade test coach");
			team.addPlayer(player);
			team.setCoach(coach);
			em.persist(player);
			em.persist(coach);
			em.persist(team);
			em.setFlushMode(FlushModeType.COMMIT);
			tm.commit();
		} catch (RuntimeException ex) {
			try {
				tm.rollback();
			} catch (RuntimeException rbEx) {
			}
			throw ex;
		} 
	}


	public void testDemoFlush() throws Exception
	{
		EntityManager em = null;

		// Obtain JBoss transaction
		TransactionManager tm = null;

		try{
			em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
			em.setFlushMode(FlushModeType.COMMIT);
			tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
			Player player = new Player();
			tm.begin();	
			em.persist(player);
			player.setName("zidane");
			//em.flush();
			//Query q = em.createQuery("select coach from Coach coach");
			Query q = em.createQuery("select player from Player player");
			List results = q.getResultList();
			tm.commit();

		} catch (RuntimeException ex) {
			try {
				tm.rollback();
			} catch (RuntimeException rbEx) {
			}
			throw ex;
		} 
	}

	public void initDatas() throws Exception
	{
		EntityManager em = null;

		// Obtain JBoss transaction
		TransactionManager tm = null;

		try{
			em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
			tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
			Team initialTeam = new Team();
			initialTeam.setName("initial team");
			Coach initialCoach = new Coach();
			initialCoach.setName("initial coach");
			Player firstPlayer = new Player();
			firstPlayer.setName("firstPlayer");
			initialTeam.setCoach(initialCoach);
			initialTeam.addPlayer(firstPlayer);

			Player freePlayer = new Player();
			freePlayer.setName("freePlayer");
			Coach freeCoach = new Coach();
			freeCoach.setName("freeCoach");


			tm.begin();	
			em.persist(initialTeam);
			em.persist(initialCoach);
			em.persist(firstPlayer);
			em.persist(freeCoach);
			em.persist(freePlayer);
			tm.commit();

		} catch (RuntimeException ex) {
			try {
				tm.rollback();
			} catch (RuntimeException rbEx) {
			}
			throw ex;
		} 
	}

	public void testSessionBean() throws Exception
	{
		initDatas();
		InitialContext ctx = new InitialContext();
		TeamManager teamManagerBmt = (TeamManager) ctx.lookup("TeamManagerBeanBmt/local");
		List<Team> teams = teamManagerBmt.getAllTeams();

		TeamManager teamManagerCmt = (TeamManager) ctx.lookup("TeamManagerBeanCmt/local");
		teams = teamManagerCmt.getAllTeams();
		Team team = teams.get(0);
		team.setName("new name");
		teamManagerCmt.merge(team);
		

	}

	public void testConversation() throws Exception
	{
		initDatas();
		InitialContext ctx = new InitialContext();
		//ConversationDemo teamManager = (ConversationDemo) ctx.lookup("ConversationDemoDetached/local");
		ConversationDemo teamManager = (ConversationDemo) ctx.lookup("ConversationDemoExtended/local");

		// tape zro, on rcupre toutes les quipes
		// pour faire notre choix
		List<Team> teams = teamManager.getAllTeams();

		//dbut de la conversation, on dmarre de l'id
		//de l'quipe  modifier
		int teamToModifyId = teams.get(0).getId();

		// tape 1 : rcupration de l'quipe
		Team teamToModify = teamManager.getTeam(teamToModifyId);

		// tape 2 : modification du nom
		teamToModify.setName("new name");

		// tape 3 : modification du coach
		List<Coach> freeCoachs = teamManager.getFreeCoachs();
		Coach previousCoach = teamToModify.getCoach();
		previousCoach.setName("une petite modification");
		Coach nextCoach = freeCoachs.get(0);
		nextCoach.setName("I'm your new coach");
		teamToModify.setCoach(nextCoach);

		// tape 4 : modfication de l'effectif jouers
		List<Player> freePlayers = teamManager.getFreePlayers();
		teamToModify.addPlayer(freePlayers.get(0));

		// tape finale : validation
		// teamManager.validateModification(teamToModify);
		
		// on peut aussi utiliser cette ligne en cas de
		// contexte de persistance tendu
		teamManager.validateModification();

	}

	public void testStupidBatch() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();

		for ( int i=0; i<100000; i++ ) {
		   Team team = new Team();
		   em.persist(team);
		}
		
		tm.commit();
	}
	
	public void testBatch() throws Exception
	{
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();

		for ( int i=0; i<100000; i++ ) {
		   Team team = new Team();
		   em.persist(team);
		   if(i % 20 == 0){
			   em.flush();
			   em.clear();
		   }
		}
		
		tm.commit();
	}
	
	public void testScroll() throws Exception
	{	
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		Session session = (Session)em.getDelegate();
		tm.begin();
		ScrollableResults teams = session.getNamedQuery("GetTeams")
		.scroll(ScrollMode.FORWARD_ONLY);
		int count=0;
		while ( teams.next() ) {
			Team team = (Team) teams.get(0);
			//team.updateStuff(...);
			if ( ++count % 20 == 0 ) {
				//synchronise la base de donnes avec les mises
				// jour et libre la mmoire
				session.flush();
				session.clear();
			}
		}
		tm.commit();
	}

	public void testDmlUpdate() throws Exception
	{	
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Query q = em.createQuery("update Team t set t.name = :param");
		q.setParameter("param", "blah");
		q.executeUpdate();
		tm.commit();
	}

	public void testDmlDelete() throws Exception
	{	
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Query q = em.createQuery("delete Team t set t.name = :param");
		q.setParameter("param", "blah");
		q.executeUpdate();
		tm.commit();
	}


}
