package ch8Tests;

import java.util.Map;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.hibernate.EntityMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch8.demoFilter.Coach;
import ch8.demoFilter.Game;
import ch8.demoFilter.Player;
import ch8.demoFilter.Team;






/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch8CallBackTestCase extends BaseTestCase
{
	public Ch8CallBackTestCase()
	{
		super("Ch8CallBackTestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch8CallBackTestCase.jar");

		jar.addClass(Team.class);
		jar.addClass(Coach.class);
		jar.addClass(Player.class);
		jar.addClass(Game.class);
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch8CallBackTestCase.class);
	}


	public void initDatas() throws Exception
	{
		EntityManager em = null;

		// Obtain JBoss transaction
		TransactionManager tm = null;

		try{
			em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
			tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
			Team initialTeam = new Team();
			initialTeam.setName("initial team");
			Coach initialCoach = new Coach();
			initialCoach.setName("initial coach");
			Player firstPlayer = new Player();
			firstPlayer.setName("firstPlayer");
			initialTeam.setCoach(initialCoach);
			initialTeam.addPlayer(firstPlayer);

			Player freePlayer = new Player();
			freePlayer.setName("freePlayer");
			Coach freeCoach = new Coach();
			freeCoach.setName("freeCoach");


			tm.begin();	
			em.persist(initialTeam);
			em.persist(initialCoach);
			em.persist(firstPlayer);
			em.persist(freeCoach);
			em.persist(freePlayer);
			tm.commit();

		} catch (RuntimeException ex) {
			try {
				tm.rollback();
			} catch (RuntimeException rbEx) {
			}
			throw ex;
		} 
	}

	public void testLoadListener() throws Exception
	{
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();
		//Session session = (Session)em.getDelegate();
		em.find(Team.class, new Integer(1));
		tm.commit();
		
	}


}
