package ch8Tests;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch8.demoCompositeId.Coach;
import ch8.demoCompositeId.Country;
import ch8.demoCompositeId.IdTeam;
import ch8.demoCompositeId.Player;
import ch8.demoCompositeId.Team;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch8CompositeIdTestCase extends BaseTestCase
{
	public Ch8CompositeIdTestCase()
	{
		super("Ch8CompositeIdTestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch8CompositeIdTestCase.jar");
		jar.addClass(Team.class);
		jar.addClass(Coach.class);
		jar.addClass(IdTeam.class);
		jar.addClass(Country.class);
		jar.addClass(Player.class);
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch8CompositeIdTestCase.class);
	}


	public void test() throws Exception  {
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		Country country = new Country();
		country.setName("france");
		
		IdTeam id = new IdTeam();
		id.setCountry(country);
		id.setName("les bleus");
		id.setYear(1769);
		
		Team team = new Team();
		team.setId(id);
		
		tm.begin();
		em.persist(country);
		em.persist(team);
        tm.commit();
        
		tm.begin();
		em.clear();
		em.find(Team.class, id);
        tm.commit();
    }
}
