package ch8Tests;

import java.util.Collection;
import java.util.List;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.hibernate.Filter;
import org.hibernate.Session;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch8.demoFilter.Coach;
import ch8.demoFilter.Game;
import ch8.demoFilter.Player;
import ch8.demoFilter.Team;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch8FilterTestCase extends BaseTestCase
{
	public Ch8FilterTestCase()
	{
		super("Ch8FilterTestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch8FilterTestCase.jar");

		jar.addClass(Team.class);
		jar.addClass(Coach.class);
		jar.addClass(Player.class);
		jar.addClass(Game.class);
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch8FilterTestCase.class);
	}


	public void initDatas() throws Exception
	{
		EntityManager em = null;

		// Obtain JBoss transaction
		TransactionManager tm = null;

		try{
			em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
			tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
			Team om = new Team();
			om.setName("om");
			Player cisse = new Player();
			cisse.setName("cisse");
			cisse.setHeight(new Float("1.85"));
			om.addPlayer(cisse);
			
			Team ol = new Team();
			ol.setName("ol");
			Player chris = new Player();
			chris.setName("chris");
			chris.setHeight(new Float("2.01"));
			om.addPlayer(chris);
			
			Game game= new Game();
			game.setAwayTeam(ol);
			game.setHomeTeam(om);
			game.setMostValuablePlayer(chris);
			
			tm.begin();	
			em.persist(om);
			em.persist(cisse);
			em.persist(ol);
			em.persist(chris);
			em.persist(game);
			tm.commit();

		} catch (RuntimeException ex) {
			try {
				tm.rollback();
			} catch (RuntimeException rbEx) {
			}
			throw ex;
		} 
	}

	public void testSessionFilter() throws Exception
	{
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();
		Session session = (Session)em.getDelegate();
		Team t = (Team)session.get(Team.class,new Integer(1));
		Collection smallPlayers = session.createFilter(
		  t.getPlayers(), 
		  "where this.height < :height ")
		  .setParameter( "height", new Float(1.88))
		  .list();
	
		tm.commit();
	}

	public void testStatiqueFilter() throws Exception
	{
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		// vrifiez les traces SQL gnres et l'inclusion
		// de la clause where paramtr via @Where
		Team team = em.find(Team.class, new Integer(1));
		System.out.println(team.getPlayers().iterator().next().getName());
		tm.commit();
	}

	public void testDynamiqueFilterEntity() throws Exception
	{
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Session session = (Session)em.getDelegate();
		Filter filter = session.enableFilter("limitPlayerByHeight");
		filter.setParameter("height", new Float(1.88));
		List results = session.createQuery("from Player p").list();
		tm.commit();
	}

	public void testDynamiqueFilterCollection() throws Exception
	{
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Session session = (Session)em.getDelegate();
		Filter filter = session.enableFilter("limitPlayerByHeight");
		filter.setParameter("height", new Float(1.88));
		List results = session.createQuery("from Team t left join fetch t.players").list();
		tm.commit();
	}


}
