package ch8Tests;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch8.demoFormula.BigPlayer;
import ch8.demoFormula.Coach;
import ch8.demoFormula.Game;
import ch8.demoFormula.Player;
import ch8.demoFormula.SmallPlayer;
import ch8.demoFormula.Team;





/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch8FormulaTestCase extends BaseTestCase
{
	public Ch8FormulaTestCase()
	{
		super("Ch8FormulaTestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch8FormulaTestCase.jar");

		jar.addClass(Team.class);
		jar.addClass(Coach.class);
		jar.addClass(Player.class);
		jar.addClass(BigPlayer.class);
		jar.addClass(SmallPlayer.class);
		jar.addClass(Game.class);
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch8FormulaTestCase.class);
	}


	public void initDatas() throws Exception
	{
		EntityManager em = null;

		// Obtain JBoss transaction
		TransactionManager tm = null;

		try{
			em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
			tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
			Team om = new Team();
			om.setName("om");
			Player cisse = new Player();
			cisse.setName("cisse");
			cisse.setHeight(new Float("1.85"));
			om.addPlayer(cisse);
			
			Team ol = new Team();
			ol.setName("ol");
			Player chris = new Player();
			chris.setName("chris");
			chris.setHeight(new Float("2.01"));
			om.addPlayer(chris);
			
			Game game= new Game();
			game.setAwayTeam(ol);
			game.setHomeTeam(om);
			game.setMostValuablePlayer(chris);
			
			tm.begin();	
			em.persist(om);
			em.persist(cisse);
			em.persist(ol);
			em.persist(chris);
			em.persist(game);
			tm.commit();

		} catch (RuntimeException ex) {
			try {
				tm.rollback();
			} catch (RuntimeException rbEx) {
			}
			throw ex;
		} 
	}

	public void testSimpleFormula() throws Exception
	{
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();

		Player chris = (Player)em.createQuery("from Player p where p.name=:param")
			.setParameter("param", "chris")
			.getSingleResult();
		// si vous testez aussi le lazy loading au niveau proprit
		// n'oubliez pas d'excuter la tache ant d'instrumentation
		assertEquals(1, chris.getHasBeenMvpCount());
		
		tm.commit();
	}


}
