package ch8Tests;

import java.util.List;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

import ch8.demoUserType.Game;
import ch8.demoUserType.Score;
import ch8.demoUserType.ScoreUserType;





/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch8UserTypeTestCase extends BaseTestCase
{
	public Ch8UserTypeTestCase()
	{
		super("Ch8UserTypeTestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch8UserTypeTestCase.jar");

		jar.addClass(Game.class);
		jar.addClass(Score.class);
		jar.addClass(ScoreUserType.class);
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch8UserTypeTestCase.class);
	}


	public void initDatas() throws Exception
	{
		EntityManager em = null;

		// Obtain JBoss transaction
		TransactionManager tm = null;

		try{
			em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
			tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
			tm.begin();
			Game game = new Game();
			Score score = new Score();
			score.setHomeTeamScore(3);
			score.setAwayTeamScore(0);
			game.setScore(score);
			em.persist(game);
			tm.commit();

		} catch (RuntimeException ex) {
			try {
				tm.rollback();
			} catch (RuntimeException rbEx) {
			}
			throw ex;
		} 
	}

	public void testQuery() throws Exception
	{
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
		
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();

		List results = em.createQuery("from Game g ")
			.getResultList();
		Game game = (Game)results.get(0);
		game.getScore().setAwayTeamScore(6);
		tm.commit();
				
		//detachement
		game.getScore().setAwayTeamScore(10);
		
		tm.begin();
		em.clear();
		Game attachedGame = em.merge(game);
		tm.commit();
	}


}
