package ch8Tests.mapMapping.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.hibernate.EntityMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch8TestCase extends BaseTestCase
{
	public Ch8TestCase()
	{
		super("Ch8TestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch8TestCase.jar");

		jar.addResource("ch8/demoMapMapping/Coach.hbm.xml");
		jar.addResource("ch8/demoMapMapping/Team.hbm.xml");
		jar.addResource("ch8/demoMapMapping/Player.hbm.xml");
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}

	public static Test suite()
	{
		return preProcessedTest(Ch8TestCase.class);
	}

	public void testGetCoach() throws Exception  {
		simplePersist();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();
        Session session = (Session)em.getDelegate();
        Session mapSession = session.getSession(EntityMode.MAP);
        List results = mapSession.createQuery("from Coach").list();
        tm.commit();

    }
	
    public void initDatas()throws Exception {
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Session s = (Session)em.getDelegate();
		Session mapSession = s.getSession(EntityMode.MAP);
		Transaction tx = mapSession.beginTransaction();
		// cration de lentit coach
		Map<String, Object> coach = new HashMap<String, Object>();
		coach.put("name", "dynaCoach");
	
		// cration de lentit player
		Map<String, Object> player = new HashMap<String, Object>();
		player.put("name", "dynaPlayer");
		player.put("height", 1.88);
		player.put("weight", 110.00);
	
		// cration de la collection dentits player
		List<Map> players = new ArrayList();
		players.add(player);
	
		// cration de lentit team
		Map<String, Object> team = new HashMap<String, Object>();
		team.put("nbLost",2);
		team.put("name","DynaTeam");
		team.put("coach",coach);
		team.put("players",players);
		player.put("team", team);
	
		// rendre le rseau dobjets persistant
		mapSession.persist("Team", team);
		tm.commit();
	    
	}

	public void getTeam()throws Exception {
    	initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

    	// Obtain JBoss transaction
    	TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

    	tm.begin();
    	Session s = (Session)em.getDelegate();
    	Session mapSession = s.getSession(EntityMode.MAP);
    	List results = mapSession.createQuery("from Team t ").list();
    	Map team = (Map)results.get(0);
    	List players = (List)team.get("players");
    	Map player = (Map)players.get(0);
    	String name = (String)player.get("name");

    	tm.commit();
	    
	}

	public void simplePersist()throws Exception {
	    Map coach = new HashMap();
		coach.put("name", "MAPCOACH");
	    
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
	    Session s = (Session)em.getDelegate();
	    Session mapSession = s.getSession(EntityMode.MAP);
	    Transaction tx = null ;
	    try{
	    	tx = mapSession.beginTransaction();
	    	mapSession.persist("Coach",coach);
	    	tm.commit();
	    }
	    catch (Exception e){
	        e.printStackTrace();
	    }
	}
}
