package ch8Tests.xmlMapping.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;

import junit.framework.Test;

import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.EntityMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.junit.BaseTestCase;
import org.jboss.virtual.plugins.context.vfs.AssembledContextFactory;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectory;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch8TestCase extends BaseTestCase
{
	public Ch8TestCase()
	{
		super("Ch8TestCase");
	}

	private static AssembledDirectory jar;



	//public static void deploy()
	public static void deploy()
	{
		jar = AssembledContextFactory.getInstance().create("Ch8TestCase.jar");

		//jar.mkdir("ch8").mkdir("demoXmlMapping").addResource("Coach.hbm.xml");
		jar.addResource("ch8/demoXmlMapping/Coach.hbm.xml");
		jar.addResource("ch8/demoXmlMapping/Player.hbm.xml");
		jar.addResource("ch8/demoXmlMapping/Team.hbm.xml");
		jar.addResource("myDS-ds.xml");
		jar.mkdir("META-INF").addResource("eyrolles-persistence.xml", "persistence.xml");

		try
		{
			Bootstrap.getInstance().deploy(jar);
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to deploy", e);
		}
	}

	public static void undeploy()
	{
		try
		{
			Bootstrap.getInstance().undeploy(jar);
			AssembledContextFactory.getInstance().remove(jar);
			jar = null;
		}
		catch (DeploymentException e)
		{
			throw new RuntimeException("Unable to undeploy", e);
		}
	}



	public static Test suite()
	{
		return preProcessedTest(Ch8TestCase.class);
	}

    public void initDatas()throws Exception {
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");
	
		// par mesure de commodit, nous exploitons le mode Map pour remplir la base de donnes
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	
		tm.begin();
		Session s = (Session)em.getDelegate();
		Session mapSession = s.getSession(EntityMode.MAP);
		Transaction tx = mapSession.beginTransaction();
		// cration de lentit coach
		Map<String, Object> coach = new HashMap<String, Object>();
		coach.put("name", "dynaCoach");
	
		// cration de lentit player
		Map<String, Object> player = new HashMap<String, Object>();
		player.put("name", "dynaPlayer");
		player.put("height", 1.88);
		player.put("weight", 110.00);
	
		// cration de la collection dentits player
		List<Map> players = new ArrayList();
		players.add(player);
	
		// cration de lentit team
		Map<String, Object> team = new HashMap<String, Object>();
		team.put("nbLost",2);
		team.put("name","DynaTeam");
		team.put("coach",coach);
		team.put("players",players);
		player.put("team", team);
	
		// rendre le rseau dobjets persistant
		mapSession.persist("Team", team);
		tm.commit();
	    
	}

	public void testGetCoach() throws Exception  {
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();
        Session session = (Session)em.getDelegate();
        Transaction tx = null ;
        Session dom4jSession = session.getSession(EntityMode.DOM4J);
        tx = dom4jSession.beginTransaction();
        List elements = dom4jSession.createQuery("from Coach").list();
        for (int i=0; i<elements.size(); i++) {
            print( (Element) elements.get(i) );
        }
        tm.commit();

    }
	
	public void testGetTeam() throws Exception  {
		initDatas();
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");

		tm.begin();
        Session session = (Session)em.getDelegate();
        Session dom4jSession = session.getSession(EntityMode.DOM4J);
        List elements = dom4jSession.createQuery("from Team").list();
        for (int i=0; i<elements.size(); i++) {
            print( (Element) elements.get(i) );
        }
        tm.commit();

    }
	
    public void simplePersist()throws Exception {

	    
		EntityManager em = (EntityManager) new InitialContext().lookup("java:/EntityManagers/eyrollesEntityManager");

		// Obtain JBoss transaction
		TransactionManager tm = (TransactionManager) new InitialContext().lookup("java:/TransactionManager");
	    Element coach = DocumentFactory.getInstance().createElement("Coach");
	    coach.addAttribute( "name","XMLCOACH" );
	    print(coach);
		tm.begin();
	    Session s = (Session)em.getDelegate();
	    Session dom4jSession = s.getSession(EntityMode.DOM4J);
    	dom4jSession.persist("ch8.demoXmlMapping.Coach",coach);
    	tm.commit();
	}
	
	
    public static void print(Element elt) throws Exception {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        // outformat.setEncoding(aEncodingScheme);
        XMLWriter writer = new XMLWriter( System.out, outformat );
        writer.write( elt );
        writer.flush();
        // System.out.println( elt.asXML() );
    }	


}
