/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jbossatx.jta;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.coordinator.TxStats;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.jbossatx.agent.LocalJBossAgentImpl;
import com.arjuna.ats.internal.jbossatx.jta.PropagationContextManager;
import com.arjuna.ats.internal.jbossatx.jta.jca.XATerminator;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.UserTransactionImple;
import com.arjuna.ats.internal.tsmx.mbeans.PropertyServiceJMXPlugin;
import com.arjuna.ats.jbossatx.jta.TransactionManagerDelegate;
import com.arjuna.ats.jbossatx.jta.TransactionManagerServiceMBean;
import com.arjuna.ats.jta.UserTransaction;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.utils.JNDIManager;
import com.arjuna.common.util.propertyservice.PropertyManager;
import com.arjuna.common.util.propertyservice.PropertyManagerFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.management.InstanceNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.transaction.TransactionManager;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.JBossXATerminator;
import org.jboss.tm.LastResource;
import org.jboss.tm.XAExceptionFormatter;

public class TransactionManagerService
extends ServiceMBeanSupport
implements TransactionManagerServiceMBean,
NotificationListener {
    public static final String PROPAGATE_FULL_CONTEXT_PROPERTY = "com.arjuna.ats.jbossatx.jta.propagatefullcontext";
    private static final String SERVICE_NAME = "TransactionManagerService";
    private static final String PROPAGATION_CONTEXT_IMPORTER_JNDI_REFERENCE = "java:/TransactionPropagationContextImporter";
    private static final String PROPAGATION_CONTEXT_EXPORTER_JNDI_REFERENCE = "java:/TransactionPropagationContextExporter";
    private static final JBossXATerminator TERMINATOR;
    private RecoveryManager _recoveryManager;
    private boolean _runRM = true;
    private int timeout;
    private boolean started;
    private byte[] startedLock = new byte[0];

    public String getName() {
        return SERVICE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        byte[] byArray = this.startedLock;
        synchronized (this.startedLock) {
            block10: {
                this.started = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.getLog().info("JBossTS Transaction Service (JTA version) - JBoss Inc.");
                this.getLog().info("Setting up property manager MBean and JMX layer");
                LocalJBossAgentImpl.setLocalAgent(this.getServer());
                System.setProperty("com.arjuna.ats.tsmx.agentimpl", LocalJBossAgentImpl.class.getName());
                System.setProperty("com.arjuna.ats.jta.lastResourceOptimisationInterface", LastResource.class.getName());
                if (this.timeout != 0) {
                    TxControl.setDefaultTimeout(this.timeout);
                }
                arjPropertyManager.propertyManager.addManagementPlugin(new PropertyServiceJMXPlugin());
                try {
                    this.bindRef(PROPAGATION_CONTEXT_IMPORTER_JNDI_REFERENCE, PropagationContextManager.class.getName());
                    this.bindRef(PROPAGATION_CONTEXT_EXPORTER_JNDI_REFERENCE, PropagationContextManager.class.getName());
                }
                catch (Exception e) {
                    this.getLog().fatal("Failed to create and register Propagation Context Manager", e);
                }
                try {
                    if (this._runRM) {
                        this.registerNotification();
                        this.getLog().info("Starting recovery manager");
                        RecoveryManager.delayRecoveryManagerThread();
                        this._recoveryManager = RecoveryManager.manager();
                        this.getLog().info("Recovery manager started");
                        break block10;
                    }
                    if (this.isRecoveryManagerRunning()) {
                        this.getLog().info("Using external recovery manager");
                        break block10;
                    }
                    this.getLog().fatal("Recovery manager not found - please refer to the JBossTS documentation for details");
                    throw new Exception("Recovery manager not found - please refer to the JBossTS documentation for details");
                }
                catch (Exception e) {
                    this.getLog().fatal("Failed to start recovery manager", e);
                    throw e;
                }
            }
            this.getLog().info("Binding TransactionManager JNDI Reference");
            jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaTMImplementation", TransactionManagerDelegate.class.getName());
            jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaUTImplementation", UserTransactionImple.class.getName());
            jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.jtaTSRImplementation", TransactionSynchronizationRegistryImple.class.getName());
            jtaPropertyManager.propertyManager.setProperty("com.arjuna.ats.jta.utils.TSRJNDIContext", "TransactionSynchronizationRegistry");
            JNDIManager.bindJTATransactionManagerImplementation();
            JNDIManager.bindJTATransactionSynchronizationRegistryImplementation();
            return;
        }
    }

    public void handleNotification(Notification notification, Object param) {
        this._recoveryManager.startRecoveryManagerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRecoveryManagerRunning() throws Exception {
        boolean active = false;
        int port = 0;
        PropertyManager pm = PropertyManagerFactory.getPropertyManager("com.arjuna.ats.propertymanager", "recoverymanager");
        if (pm != null) {
            String portStr = pm.getProperty("com.arjuna.ats.internal.arjuna.recovery.recoveryPort");
            if (portStr != null) {
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (Exception ex) {
                    port = -1;
                }
            } else {
                throw new Exception("The transaction status manager port is not set - please refer to the JBossTS documentation");
            }
            BufferedReader in = null;
            PrintStream out = null;
            try {
                this.getLog().info("Connecting to recovery manager on port " + port);
                Socket sckt = new Socket(InetAddress.getLocalHost(), port);
                in = new BufferedReader(new InputStreamReader(sckt.getInputStream()));
                out = new PrintStream(sckt.getOutputStream());
                out.println("PING");
                String inMessage = in.readLine();
                active = inMessage != null ? inMessage.equals("PONG") : false;
            }
            catch (Exception ex) {
                this.getLog().error("Failed to connect to recovery manager", ex);
                active = false;
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        return active;
    }

    protected void destroyService() throws Exception {
        if (this._runRM) {
            this.getLog().info("Stopping recovery manager");
            this._recoveryManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionTimeout(int timeout) throws IllegalStateException {
        byte[] byArray = this.startedLock;
        synchronized (this.startedLock) {
            if (this.started) {
                if (this.timeout != timeout) {
                    throw new IllegalStateException("Cannot set transaction timeout once MBean has started");
                }
            } else {
                this.timeout = timeout;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionTimeout() {
        byte[] byArray = this.startedLock;
        synchronized (this.startedLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.started ? this.timeout : TxControl.getDefaultTimeout();
        }
    }

    public TransactionManager getTransactionManager() {
        return com.arjuna.ats.jta.TransactionManager.transactionManager();
    }

    public JBossXATerminator getXATerminator() {
        return TERMINATOR;
    }

    public javax.transaction.UserTransaction getUserTransaction() {
        return UserTransaction.userTransaction();
    }

    public void setPropagateFullContext(boolean propagateFullContext) {
    }

    public boolean getPropagateFullContext() {
        return false;
    }

    public void setStatisticsEnabled(boolean enabled) {
        System.setProperty("com.arjuna.ats.arjuna.coordinator.enableStatistics", enabled ? "YES" : "NO");
    }

    public boolean getStatisticsEnabled() {
        boolean enabled = System.getProperty("com.arjuna.ats.arjuna.coordinator.enableStatistics", "NO").equals("YES");
        return enabled;
    }

    public void registerXAExceptionFormatter(Class c, XAExceptionFormatter f) {
        this.getLog().warn("XAExceptionFormatters are not supported by the JBossTS Transaction Service - this warning can safely be ignored");
    }

    public void unregisterXAExceptionFormatter(Class c) {
    }

    public long getTransactionCount() {
        return TxStats.numberOfTransactions();
    }

    public long getCommitCount() {
        return TxStats.numberOfCommittedTransactions();
    }

    public long getRollbackCount() {
        return TxStats.numberOfAbortedTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunInVMRecoveryManager(boolean runRM) throws IllegalStateException {
        byte[] byArray = this.startedLock;
        synchronized (this.startedLock) {
            if (this.started) {
                if (this._runRM != runRM) {
                    throw new IllegalStateException("Cannot set run in VM recovery manager once MBean has started");
                }
            } else {
                this._runRM = runRM;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRunInVMRecoveryManager() {
        byte[] byArray = this.startedLock;
        synchronized (this.startedLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._runRM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectStoreDir(String objectStoreDir) throws IllegalStateException {
        byte[] byArray = this.startedLock;
        synchronized (this.startedLock) {
            if (this.started) {
                boolean equal;
                String currentDir = this.getObjectStoreDir();
                boolean bl = currentDir == null ? objectStoreDir == null : (equal = currentDir.equals(objectStoreDir));
                if (!equal) {
                    throw new IllegalStateException("Cannot set object store dir once MBean has started");
                }
            } else {
                System.setProperty("com.arjuna.ats.arjuna.objectstore.objectStoreDir", objectStoreDir);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getObjectStoreDir() {
        return System.getProperty("com.arjuna.ats.arjuna.objectstore.objectStoreDir");
    }

    private void registerNotification() throws InstanceNotFoundException {
        NotificationFilterSupport notificationFilter = new NotificationFilterSupport();
        notificationFilter.enableType("org.jboss.system.server.started");
        ObjectName serverName = ObjectNameFactory.create("jboss.system:type=Server");
        this.getServer().addNotificationListener(serverName, this, (NotificationFilter)notificationFilter, null);
    }

    private void bindRef(String jndiName, String className) throws Exception {
        Reference ref = new Reference(className, className, null);
        new InitialContext().bind(jndiName, (Object)ref);
    }

    static {
        arjPropertyManager.propertyManager.setProperty("com.arjuna.common.util.logger", "log4j_releveler");
        TERMINATOR = new XATerminator();
    }
}

