/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.jboss.system.server.Server;
import org.jboss.system.server.ServerConfigUtil;
import org.jboss.system.server.ServerLoader;

public class Main {
    private String concurrentLib = "concurrent.jar";
    private URL bootURL;
    private List bootLibraries = new LinkedList();
    private List extraLibraries = new LinkedList();
    private List extraClasspath = new LinkedList();
    private Properties props = new Properties(System.getProperties());
    private Server server;

    public Server getServer() {
        return this.server;
    }

    public void boot(String[] args) throws Exception {
        int i;
        this.processCommandLine(args);
        String homeDir = this.props.getProperty("jboss.home.dir");
        if (homeDir == null) {
            String path = Main.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            path = URLDecoder.decode(path, "UTF-8");
            File runJar = new File(path);
            File homeFile = runJar.getParentFile().getParentFile();
            homeDir = homeFile.getCanonicalPath();
        }
        this.props.setProperty("jboss.home.dir", homeDir);
        String homeURL = this.props.getProperty("jboss.home.url");
        if (homeURL == null) {
            File file = new File(homeDir);
            homeURL = file.toURL().toString();
            this.props.setProperty("jboss.home.url", homeURL);
        }
        ServerLoader loader = new ServerLoader(this.props);
        if (this.bootURL != null) {
            if (this.bootURL.getProtocol().equals("file")) {
                File dir = new File(this.bootURL.getFile());
                if (dir.exists()) {
                    loader.addURL(dir.toURL());
                    File[] jars = dir.listFiles(new JarFilter());
                    for (int j = 0; jars != null && j < jars.length; ++j) {
                        loader.addURL(jars[j].getCanonicalFile().toURL());
                    }
                }
            } else {
                loader.addURL(this.bootURL);
            }
        }
        for (i = 0; i < this.bootLibraries.size(); ++i) {
            loader.addLibrary((String)this.bootLibraries.get(i));
        }
        loader.addEndorsedJars();
        loader.addLibrary(this.concurrentLib);
        for (i = 0; i < this.extraLibraries.size(); ++i) {
            loader.addLibrary((String)this.extraLibraries.get(i));
        }
        for (i = 0; i < this.extraClasspath.size(); ++i) {
            loader.addURL((URL)this.extraClasspath.get(i));
        }
        ClassLoader parentCL = Thread.currentThread().getContextClassLoader();
        this.server = loader.load(parentCL);
        this.server.init(this.props);
        this.server.start();
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    private void processCommandLine(String[] args) throws Exception {
        int code;
        String programName = System.getProperty("program.name", "jboss");
        String sopts = "-:hD:d:p:n:c:Vj::B:L:C:P:b:g:u:m:l:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("bootdir", 1, null, 100), new LongOpt("patchdir", 1, null, 112), new LongOpt("netboot", 1, null, 110), new LongOpt("configuration", 1, null, 99), new LongOpt("version", 0, null, 86), new LongOpt("jaxp", 1, null, 106), new LongOpt("bootlib", 1, null, 66), new LongOpt("library", 1, null, 76), new LongOpt("classpath", 1, null, 67), new LongOpt("properties", 1, null, 80), new LongOpt("host", 1, null, 98), new LongOpt("partition", 1, null, 103), new LongOpt("udp", 1, null, 117), new LongOpt("mcast_port", 1, null, 109), new LongOpt("log", 1, null, 108)};
        Getopt getopt = new Getopt(programName, args, sopts, lopts);
        this.props.setProperty("jboss.bind.address", "0.0.0.0");
        System.setProperty("jboss.bind.address", "0.0.0.0");
        block21: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    System.exit(1);
                    continue block21;
                }
                case 1: {
                    System.err.println(programName + ": unused non-option argument: " + getopt.getOptarg());
                    continue block21;
                }
                case 104: {
                    System.out.println("usage: " + programName + " [options]");
                    System.out.println();
                    System.out.println("options:");
                    System.out.println("    -h, --help                    Show this help message");
                    System.out.println("    -V, --version                 Show version information");
                    System.out.println("    --                            Stop processing options");
                    System.out.println("    -D<name>[=<value>]            Set a system property");
                    System.out.println("    -d, --bootdir=<dir>           Set the boot patch directory; Must be absolute or url");
                    System.out.println("    -p, --patchdir=<dir>          Set the patch directory; Must be absolute or url");
                    System.out.println("    -n, --netboot=<url>           Boot from net with the given url as base");
                    System.out.println("    -c, --configuration=<name>    Set the server configuration name");
                    System.out.println("    -B, --bootlib=<filename>      Add an extra library to the front bootclasspath");
                    System.out.println("    -L, --library=<filename>      Add an extra library to the loaders classpath");
                    System.out.println("    -C, --classpath=<url>         Add an extra url to the loaders classpath");
                    System.out.println("    -P, --properties=<url>        Load system properties from the given url");
                    System.out.println("    -b, --host=<host or ip>       Bind address for all JBoss services");
                    System.out.println("    -g, --partition=<name>        HA Partition name (default=DefaultDomain)");
                    System.out.println("    -m, --mcast_port=<ip>         UDP multicast port; Only used by JGroups multiplexer");
                    System.out.println("    -u, --udp=<ip>                UDP multicast address");
                    System.out.println("    -l, --log=<log4j|jdk>         Specify the logger plugin type");
                    System.out.println();
                    System.exit(0);
                    continue block21;
                }
                case 68: {
                    String value;
                    String name;
                    String arg = getopt.getOptarg();
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    System.setProperty(name, value);
                    if (!"bind.address".equals(name)) continue block21;
                    String addr = ServerConfigUtil.fixRemoteAddress(value);
                    System.setProperty("jgroups.bind_addr", addr);
                    continue block21;
                }
                case 100: {
                    this.bootURL = this.makeURL(getopt.getOptarg());
                    continue block21;
                }
                case 112: {
                    URL patchURL = this.makeURL(getopt.getOptarg());
                    this.props.put("jboss.patch.url", patchURL.toString());
                    continue block21;
                }
                case 110: {
                    String arg = getopt.getOptarg();
                    if (!arg.endsWith("/")) {
                        arg = arg + "/";
                    }
                    this.props.put("jboss.home.url", new URL(arg).toString());
                    continue block21;
                }
                case 99: {
                    String arg = getopt.getOptarg();
                    this.props.put("jboss.server.name", arg);
                    continue block21;
                }
                case 86: {
                    Package jbossPackage = Package.getPackage("org.jboss");
                    System.out.println("JBoss " + jbossPackage.getImplementationVersion());
                    System.out.println();
                    System.out.println("Distributable under LGPL license.");
                    System.out.println("See terms of license at gnu.org.");
                    System.out.println();
                    System.exit(0);
                    continue block21;
                }
                case 106: {
                    System.err.println(programName + ": option '-j, --jaxp' no longer supported");
                    System.exit(1);
                    continue block21;
                }
                case 66: {
                    String arg = getopt.getOptarg();
                    this.bootLibraries.add(arg);
                    continue block21;
                }
                case 76: {
                    String arg = getopt.getOptarg();
                    this.extraLibraries.add(arg);
                    continue block21;
                }
                case 67: {
                    URL url = this.makeURL(getopt.getOptarg());
                    this.extraClasspath.add(url);
                    continue block21;
                }
                case 80: {
                    URL url = this.makeURL(getopt.getOptarg());
                    Properties props = System.getProperties();
                    props.load(url.openConnection().getInputStream());
                    continue block21;
                }
                case 98: {
                    String rmiHost;
                    String arg = getopt.getOptarg();
                    this.props.put("jboss.bind.address", arg);
                    System.setProperty("jboss.bind.address", arg);
                    String bindAddress = System.getProperty("bind.address");
                    if (bindAddress == null) {
                        bindAddress = ServerConfigUtil.fixRemoteAddress(arg);
                        System.setProperty("bind.address", bindAddress);
                    }
                    if ((bindAddress = System.getProperty("jgroups.bind_addr")) == null) {
                        bindAddress = ServerConfigUtil.fixRemoteAddress(arg);
                        System.setProperty("jgroups.bind_addr", bindAddress);
                    }
                    if ((rmiHost = System.getProperty("java.rmi.server.hostname")) != null) continue block21;
                    rmiHost = ServerConfigUtil.fixRemoteAddress(arg);
                    System.setProperty("java.rmi.server.hostname", rmiHost);
                    continue block21;
                }
                case 103: {
                    String arg = getopt.getOptarg();
                    this.props.put("jboss.partition.name", arg);
                    System.setProperty("jboss.partition.name", arg);
                    continue block21;
                }
                case 117: {
                    String arg = getopt.getOptarg();
                    this.props.put("jboss.partition.udpGroup", arg);
                    System.setProperty("jboss.partition.udpGroup", arg);
                    System.setProperty("jgroups.udp.mcast_addr", arg);
                    continue block21;
                }
                case 109: {
                    String arg = getopt.getOptarg();
                    this.props.put("jgroups.udp.mcast_port", arg);
                    System.setProperty("jgroups.udp.mcast_port", arg);
                    continue block21;
                }
                case 108: {
                    String arg;
                    String logPlugin = arg = getopt.getOptarg();
                    if (arg.equalsIgnoreCase("log4j")) {
                        logPlugin = "org.jboss.logging.Log4jLoggerPlugin";
                    } else if (arg.equalsIgnoreCase("jdk")) {
                        logPlugin = "org.jboss.logging.JDK14LoggerPlugin";
                        System.setProperty("java.util.logging.manager", "org.jboss.logging.jdk.JDKLogManager");
                    }
                    System.setProperty("org.jboss.logging.Logger.pluginClass", logPlugin);
                    continue block21;
                }
            }
            throw new Error("unhandled option code: " + code);
        }
    }

    public static void main(final String[] args) throws Exception {
        Runnable worker = new Runnable(){

            public void run() {
                try {
                    Main main = new Main();
                    main.boot(args);
                }
                catch (Exception e) {
                    System.err.println("Failed to boot JBoss:");
                    e.printStackTrace();
                }
            }
        };
        ThreadGroup threads = new ThreadGroup("jboss");
        new Thread(threads, worker, "main").start();
    }

    public static void systemExit(String[] argv) {
        System.exit(0);
    }

    static class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

