/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure.vfs;

import org.jboss.deployers.spi.structure.vfs.StructureDeployer;
import org.jboss.deployers.spi.structure.vfs.StructureMetaData;
import org.jboss.deployers.spi.structure.vfs.StructuredDeployers;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;

public class StructureDeployerWrapper
implements StructureDeployer {
    private Logger log;
    private StructureDeployer deployer;

    public StructureDeployerWrapper(StructureDeployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.deployer = deployer;
        this.log = Logger.getLogger(deployer.getClass());
    }

    public boolean determineStructure(VirtualFile root, StructureMetaData metaData, StructuredDeployers deployers) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        try {
            boolean result = deployers.determineStructure(root, metaData);
            if (this.log.isTraceEnabled()) {
                if (!result) {
                    this.log.trace("Not recognised: " + root.getName());
                } else {
                    this.log.trace("Recognised: " + root.getName());
                }
            }
            return result;
        }
        catch (Throwable t) {
            this.log.warn("Error during determineStructure: " + root.getName(), t);
            return false;
        }
    }

    public int getRelativeOrder() {
        return this.deployer.getRelativeOrder();
    }

    public void setRelativeOrder(int order) {
        this.deployer.setRelativeOrder(order);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof StructureDeployer)) {
            return false;
        }
        if (obj instanceof StructureDeployerWrapper) {
            obj = ((StructureDeployerWrapper)obj).deployer;
        }
        return this.deployer.equals(obj);
    }

    public int hashCode() {
        return this.deployer.hashCode();
    }

    public String toString() {
        return this.deployer.toString();
    }
}

