/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.Ejb3Deployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss5DeploymentScope
implements DeploymentScope {
    private ConcurrentHashMap<String, Ejb3Deployment> deployments;
    private String shortName;
    private String baseName;

    public JBoss5DeploymentScope(DeploymentContext parent) {
        this.shortName = parent.getRoot().getPathName();
        if (this.shortName.length() == 0) {
            this.shortName = parent.getName();
            if (this.shortName.endsWith("!/")) {
                this.shortName = this.shortName.substring(0, this.shortName.length() - 2);
            }
        }
        int x = this.shortName.lastIndexOf(47);
        this.baseName = this.shortName = this.shortName.substring(x + 1);
        int idx = this.shortName.lastIndexOf(46);
        if (idx > 0) {
            this.baseName = this.shortName.substring(0, idx);
        }
        this.deployments = (ConcurrentHashMap)parent.getDeploymentUnit().getAttachment("EJB_DEPLOYMENTS");
        if (this.deployments == null) {
            this.deployments = new ConcurrentHashMap();
            parent.getDeploymentUnit().addAttachment("EJB_DEPLOYMENTS", this.deployments);
        }
    }

    @Override
    public Collection<Ejb3Deployment> getEjbDeployments() {
        return this.deployments.values();
    }

    @Override
    public void register(Ejb3Deployment deployment) {
        this.deployments.put(deployment.getDeploymentUnit().getShortName(), deployment);
    }

    @Override
    public void unregister(Ejb3Deployment deployment) {
        this.deployments.remove(deployment.getDeploymentUnit().getShortName());
    }

    @Override
    public Ejb3Deployment findRelativeDeployment(String relativeName) {
        if (relativeName.startsWith("../")) {
            relativeName = relativeName.substring(3);
        }
        return this.deployments.get(relativeName);
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }
}

