/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb.inflow;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.mdb.inflow.GetTCLAction;
import org.jboss.ejb3.mdb.inflow.JBossMessageEndpointFactory;
import org.jboss.ejb3.mdb.inflow.SetTCLAction;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;

public class MessageInflowLocalProxy
implements InvocationHandler {
    private static final Logger log = Logger.getLogger(MessageInflowLocalProxy.class);
    public static final String MESSAGE_ENDPOINT_FACTORY = "MessageEndpoint.Factory";
    public static final String MESSAGE_ENDPOINT_XARESOURCE = "MessageEndpoint.XAResource";
    private boolean trace = log.isTraceEnabled();
    private String cachedProxyString = null;
    protected SynchronizedBoolean released = new SynchronizedBoolean(false);
    protected boolean delivered = false;
    protected Thread inUseThread = null;
    protected ClassLoader oldClassLoader = null;
    protected Transaction transaction = null;
    protected Transaction suspended = null;
    private JBossMessageEndpointFactory endpointFactory;
    private XAResource resource;
    private MessageEndpointFactory messageEndpointFactory;
    MessagingContainer container;

    protected MessageInflowLocalProxy(MessagingContainer container) {
        this.container = container;
    }

    public void setMessageEndpointFactory(MessageEndpointFactory messageEndpointFactory) {
        this.messageEndpointFactory = messageEndpointFactory;
    }

    public void setXaResource(XAResource resource) {
        this.resource = resource;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.released.get()) {
            throw new IllegalStateException("This message endpoint + " + this.getProxyString(proxy) + " has been released");
        }
        Thread currentThread = Thread.currentThread();
        if (this.inUseThread != null && !this.inUseThread.equals(currentThread)) {
            throw new IllegalStateException("This message endpoint + " + this.getProxyString(proxy) + " is already in use by another thread " + this.inUseThread);
        }
        this.inUseThread = currentThread;
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(proxy) + " in use by " + method + " " + this.inUseThread);
        }
        if (method.getName().equals("release")) {
            this.release(proxy);
            return null;
        }
        if (method.getName().equals("beforeDelivery")) {
            this.before(proxy, this.container, method, args);
            return null;
        }
        if (method.getName().equals("afterDelivery")) {
            this.after(proxy);
            return null;
        }
        return this.delivery(proxy, this.container, method, args);
    }

    public String toString() {
        return this.container.getEjbName().toString();
    }

    protected void release(Object proxy) throws Throwable {
        this.released.set(true);
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(proxy) + " released");
        }
        if (this.oldClassLoader != null) {
            try {
                this.finish("release", proxy, false);
            }
            catch (Throwable t) {
                log.warn("Error in release ", t);
            }
        }
    }

    protected void before(Object proxy, MessagingContainer container, Method method, Object[] args) throws Throwable {
        if (this.oldClassLoader != null) {
            throw new IllegalStateException("Missing afterDelivery from the previous beforeDelivery for message endpoint " + this.getProxyString(proxy));
        }
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(proxy) + " released");
        }
        this.oldClassLoader = GetTCLAction.getContextClassLoader(this.inUseThread);
        SetTCLAction.setContextClassLoader(this.inUseThread, container.getClassloader());
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(proxy) + " set context classloader to " + container.getClassloader());
        }
        try {
            MethodInfo methodInfo = container.getMethodInfo((Method)args[0]);
            boolean isTransacted = this.messageEndpointFactory.isDeliveryTransacted(methodInfo.getAdvisedMethod());
            this.startTransaction("beforeDelivery", proxy, container, method, args, isTransacted);
        }
        catch (Throwable t) {
            this.resetContextClassLoader(proxy);
            throw new ResourceException(t);
        }
    }

    protected void after(Object proxy) throws Throwable {
        if (this.oldClassLoader == null) {
            throw new IllegalStateException("afterDelivery without a previous beforeDelivery for message endpoint " + this.getProxyString(proxy));
        }
        try {
            this.finish("afterDelivery", proxy, true);
        }
        catch (Throwable t) {
            throw new ResourceException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object delivery(Object proxy, MessagingContainer container, Method method, Object[] args) throws Throwable {
        if (this.delivered) {
            throw new IllegalStateException("Multiple message delivery between before and after delivery is not allowed for message endpoint " + this.getProxyString(proxy));
        }
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(proxy) + " delivering");
        }
        if (this.oldClassLoader != null) {
            this.delivered = true;
        }
        boolean commit = true;
        MethodInfo methodInfo = container.getMethodInfo(method);
        try {
            if (this.oldClassLoader == null) {
                boolean isTransacted = this.messageEndpointFactory.isDeliveryTransacted(methodInfo.getAdvisedMethod());
                this.startTransaction("delivery", proxy, container, method, args, isTransacted);
            }
            Object isTransacted = container.localInvoke(methodInfo, args);
            return isTransacted;
        }
        catch (Throwable t) {
            if (this.trace) {
                log.trace("MessageEndpoint " + this.getProxyString(proxy) + " delivery error", t);
            }
            if (t instanceof Error || t instanceof RuntimeException) {
                if (this.transaction != null) {
                    this.transaction.setRollbackOnly();
                }
                commit = false;
            }
            throw t;
        }
        finally {
            if (this.oldClassLoader == null) {
                try {
                    this.endTransaction(proxy, commit);
                }
                finally {
                    this.releaseThreadLock(proxy);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish(String context, Object proxy, boolean commit) throws Throwable {
        try {
            this.endTransaction(proxy, commit);
        }
        finally {
            this.delivered = false;
            this.resetContextClassLoader(proxy);
            this.releaseThreadLock(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTransaction(String context, Object proxy, MessagingContainer container, Method m, Object[] args, boolean isTransacted) throws Throwable {
        Method method = "delivery".equals(context) ? m : (Method)args[0];
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(proxy) + " " + context + " method=" + method + " xaResource=" + this.resource + " transacted=" + isTransacted);
        }
        TransactionManager tm = TxUtil.getTransactionManager();
        this.suspended = tm.suspend();
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(proxy) + " " + context + " currentTx=" + this.suspended);
        }
        if (isTransacted) {
            if (this.suspended == null) {
                tm.begin();
                this.transaction = tm.getTransaction();
                if (this.trace) {
                    log.trace("MessageEndpoint " + this.getProxyString(proxy) + " started transaction=" + this.transaction);
                }
                if (this.resource != null) {
                    this.transaction.enlistResource(this.resource);
                    if (this.trace) {
                        log.trace("MessageEndpoint " + this.getProxyString(proxy) + " enlisted=" + this.resource);
                    }
                }
            } else {
                try {
                    tm.resume(this.suspended);
                }
                finally {
                    this.suspended = null;
                    if (this.trace) {
                        log.trace("MessageEndpoint " + this.getProxyString(proxy) + " transaction=" + this.suspended + " already active, IGNORED=" + this.resource);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTransaction(Object proxy, boolean commit) throws Throwable {
        block18: {
            TransactionManager tm = null;
            Transaction currentTx = null;
            try {
                if (this.transaction != null) {
                    tm = TxUtil.getTransactionManager();
                    currentTx = tm.getTransaction();
                    if (currentTx != null && !currentTx.equals(this.transaction)) {
                        log.warn("Current transaction " + currentTx + " is not the expected transaction.");
                        tm.suspend();
                        tm.resume(this.transaction);
                    } else {
                        currentTx = null;
                    }
                    if (!commit || this.transaction.getStatus() == 1) {
                        if (this.trace) {
                            log.trace("MessageEndpoint " + this.getProxyString(proxy) + " rollback");
                        }
                        tm.rollback();
                    } else {
                        if (this.trace) {
                            log.trace("MessageEndpoint " + this.getProxyString(proxy) + " commit");
                        }
                        tm.commit();
                    }
                }
                if (this.suspended == null) break block18;
                try {
                    tm = TxUtil.getTransactionManager();
                    tm.resume(this.suspended);
                }
                finally {
                    this.suspended = null;
                }
            }
            finally {
                if (currentTx != null) {
                    try {
                        tm.resume(currentTx);
                    }
                    catch (Throwable t) {
                        log.warn("MessageEndpoint " + this.getProxyString(proxy) + " failed to resume old transaction " + currentTx);
                    }
                }
            }
        }
    }

    protected void resetContextClassLoader(Object proxy) {
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(proxy) + " reset classloader " + this.oldClassLoader);
        }
        SetTCLAction.setContextClassLoader(this.inUseThread, this.oldClassLoader);
        this.oldClassLoader = null;
    }

    protected void releaseThreadLock(Object proxy) {
        if (this.trace) {
            log.trace("MessageEndpoint " + this.getProxyString(proxy) + " no longer in use by " + this.inUseThread);
        }
        this.inUseThread = null;
    }

    protected String getProxyString(Object proxy) {
        if (this.cachedProxyString == null) {
            this.cachedProxyString = this.container.getEjbName();
        }
        return this.cachedProxyString;
    }

    protected JBossMessageEndpointFactory getMessageEndpointFactory(Invocation invocation) {
        if (this.endpointFactory == null) {
            MethodInvocation mi = (MethodInvocation)invocation;
            this.endpointFactory = (JBossMessageEndpointFactory)mi.getResponseAttachment(MESSAGE_ENDPOINT_FACTORY);
        }
        return this.endpointFactory;
    }

    protected MessagingContainer getContainer(Invocation mi) {
        return this.getMessageEndpointFactory(mi).getContainer();
    }
}

