/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.ApplicationException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBException;
import org.jboss.annotation.ejb.SerializedConcurrentAccess;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.metamodel.AssemblyDescriptor;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulInstanceInterceptor
implements Interceptor {
    @Override
    public String getName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        Object object;
        boolean block;
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        Object id = ejb.getId();
        StatefulContainer container = (StatefulContainer)ejb.getAdvisor();
        StatefulBeanContext target = container.getCache().get(id);
        boolean bl = block = container.resolveAnnotation(SerializedConcurrentAccess.class) != null;
        if (block) {
            target.getLock().lockInterruptibly();
        } else {
            object = target;
            synchronized (object) {
                if (target.isInInvocation()) {
                    throw new ConcurrentAccessException("no concurrent calls on stateful bean '" + container.getName() + "' (EJB3 4.3.13)");
                }
                target.setInInvocation(true);
            }
        }
        ejb.setTargetObject(target.getInstance());
        ejb.setBeanContext(target);
        StatefulBeanContext.currentBean.push(target);
        try {
            if (target.isDiscarded()) {
                throw new EJBException("SFSB was discarded by another thread");
            }
            object = ejb.invokeNext();
            return object;
        }
        catch (Exception ex) {
            if (StatefulInstanceInterceptor.isApplicationException(ex.getClass(), container)) {
                throw ex;
            }
            if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                container.getCache().remove(id);
                target.setDiscarded(true);
            }
            throw ex;
        }
        finally {
            StatefulBeanContext.currentBean.pop();
            StatefulBeanContext statefulBeanContext = target;
            synchronized (statefulBeanContext) {
                target.setInInvocation(false);
                if (!target.isTxSynchronized() && !target.isDiscarded()) {
                    container.getCache().finished(target);
                }
                if (block) {
                    target.getLock().unlock();
                }
            }
        }
    }

    public static boolean isApplicationException(Class<?> exceptionClass, EJBContainer container) {
        List exceptions;
        if (exceptionClass.isAnnotationPresent(ApplicationException.class)) {
            return true;
        }
        AssemblyDescriptor assembly = container.getAssemblyDescriptor();
        if (assembly != null && (exceptions = assembly.getApplicationExceptions()).size() > 0) {
            for (org.jboss.ejb3.metamodel.ApplicationException exception : exceptions) {
                if (!exception.getExceptionClass().equals(exceptionClass.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

