/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.jms.client.FailoverEvent;
import org.jboss.jms.client.FailoverListener;
import org.jboss.jms.client.FailoverValve2;
import org.jboss.jms.client.FailureDetector;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.server.endpoint.CreateConnectionResult;
import org.jboss.logging.Logger;

public class FailoverCommandCenter {
    private static final Logger log = Logger.getLogger(FailoverCommandCenter.class);
    private static boolean trace = log.isTraceEnabled();
    private ConnectionState state;
    private FailoverValve2 valve;
    private List failoverListeners;

    public FailoverCommandCenter(ConnectionState state) {
        this.state = state;
        this.failoverListeners = new ArrayList();
        this.valve = new FailoverValve2();
    }

    public void setState(ConnectionState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void failureDetected(Throwable reason, FailureDetector source, JMSRemotingConnection remotingConnection) throws Exception {
        log.debug("failure detected by " + source);
        this.broadcastFailoverEvent(new FailoverEvent(10, source));
        CreateConnectionResult res = null;
        boolean failoverSuccessful = false;
        boolean valveOpened = false;
        try {
            try {
                this.valve.close();
                FailoverCommandCenter failoverCommandCenter = this;
                synchronized (failoverCommandCenter) {
                    if (remotingConnection.isFailed()) {
                        log.debug(this + " ignoring failure detection notification, as failover was " + "already (or is in process of being) performed on this connection");
                        // MONITOREXIT @DISABLED, blocks:[0, 17, 1, 4] lbl13 : MonitorExitStatement: MONITOREXIT : var7_7
                        Object var11_10 = null;
                        if (!valveOpened) {
                            this.valve.open();
                        }
                        if (failoverSuccessful) {
                            log.debug(this + " completed successful failover");
                            this.broadcastFailoverEvent(new FailoverEvent(30, this));
                            return;
                        }
                        log.debug(this + " aborted failover");
                        this.broadcastFailoverEvent(new FailoverEvent(100, this));
                        return;
                    }
                    remotingConnection.setFailed();
                }
                log.debug(this + " starting client-side failover");
                this.broadcastFailoverEvent(new FailoverEvent(20, this));
                int failedNodeID = this.state.getServerID();
                ConnectionFactoryDelegate clusteredDelegate = this.state.getClusteredConnectionFactoryDelegate();
                res = clusteredDelegate.createConnectionDelegate(this.state.getUsername(), this.state.getPassword(), failedNodeID);
                if (res == null) {
                    failoverSuccessful = false;
                } else {
                    ClientConnectionDelegate newDelegate = res.getDelegate();
                    this.state.getDelegate().synchronizeWith(newDelegate);
                    this.valve.open();
                    valveOpened = true;
                    if (this.state.isStarted()) {
                        newDelegate.start();
                    }
                    failoverSuccessful = true;
                }
            }
            catch (Exception e) {
                log.error("Failover failed", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!valveOpened) {
                this.valve.open();
            }
            if (failoverSuccessful) {
                log.debug(this + " completed successful failover");
                this.broadcastFailoverEvent(new FailoverEvent(30, this));
                throw throwable;
            }
            log.debug(this + " aborted failover");
            this.broadcastFailoverEvent(new FailoverEvent(100, this));
            throw throwable;
        }
        Object var11_11 = null;
        if (!valveOpened) {
            this.valve.open();
        }
        if (failoverSuccessful) {
            log.debug(this + " completed successful failover");
            this.broadcastFailoverEvent(new FailoverEvent(30, this));
            return;
        }
        log.debug(this + " aborted failover");
        this.broadcastFailoverEvent(new FailoverEvent(100, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFailoverListener(FailoverListener listener) {
        List list2 = this.failoverListeners;
        synchronized (list2) {
            this.failoverListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterFailoverListener(FailoverListener listener) {
        List list2 = this.failoverListeners;
        synchronized (list2) {
            return this.failoverListeners.remove(listener);
        }
    }

    public FailoverValve2 getValve() {
        return this.valve;
    }

    public JMSRemotingConnection getRemotingConnection() {
        return this.state.getRemotingConnection();
    }

    public String toString() {
        return "FailoverCommandCenter[" + this.state + "]";
    }

    ConnectionState getConnectionState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastFailoverEvent(FailoverEvent e) {
        ArrayList listenersCopy;
        if (trace) {
            log.trace(this + " broadcasting " + e);
        }
        List list2 = this.failoverListeners;
        synchronized (list2) {
            listenersCopy = new ArrayList(this.failoverListeners);
        }
        Iterator i = listenersCopy.iterator();
        while (i.hasNext()) {
            FailoverListener listener = (FailoverListener)i.next();
            try {
                listener.failoverEventOccured(e);
            }
            catch (Exception ex) {
                log.warn("Failover listener " + listener + " did not accept event", ex);
            }
        }
    }
}

