/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jms.client.remoting.CallbackManager;
import org.jboss.jms.client.remoting.ConsolidatedRemotingConnectionListener;
import org.jboss.jms.server.remoting.JMSWireFormat;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.util.id.GUID;

public class JMSRemotingConnection {
    public static final String CALLBACK_POLL_PERIOD_DEFAULT = "100";
    private static final Logger log = Logger.getLogger(JMSRemotingConnection.class);
    private Client client;
    private boolean clientPing;
    private InvokerLocator serverLocator;
    private CallbackManager callbackManager;
    protected boolean failed = false;
    private ConsolidatedRemotingConnectionListener remotingConnectionListener;

    private static String getPropertySafely(String propName) {
        String prop = null;
        try {
            prop = System.getProperty(propName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prop;
    }

    public static Map createCallbackMetadata(boolean doPushCallbacks, Map metadata, InvokerLocator serverLocator) {
        if (metadata == null) {
            metadata = new HashMap<String, String>();
        }
        metadata.put("onewayThreadPool", "org.jboss.jms.server.remoting.DirectThreadPool");
        if (doPushCallbacks) {
            String protocol;
            String propertyPort;
            metadata.put("clientSocketClass", "org.jboss.jms.client.remoting.ClientSocketWrapper");
            metadata.put("serverSocketClass", "org.jboss.jms.server.remoting.ServerSocketWrapper");
            String bindAddress = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.bind.address");
            if (bindAddress != null) {
                metadata.put("callbackServerHost", bindAddress);
            }
            if ((propertyPort = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.bind.port")) != null) {
                metadata.put("callbackServerPort", propertyPort);
            }
            if ("bisocket".equals(protocol = serverLocator.getProtocol()) || "sslbisocket".equals(protocol)) {
                metadata.put("isCallbackServer", "true");
                if (propertyPort == null) {
                    String guid = new GUID().toString();
                    int hash = guid.hashCode();
                    while (hash <= 0) {
                        if (hash == 0) {
                            guid = new GUID().toString();
                            hash = guid.hashCode();
                        }
                        if (hash >= 0) continue;
                        if (hash == Integer.MIN_VALUE) {
                            hash = Integer.MAX_VALUE;
                            continue;
                        }
                        hash = -hash;
                    }
                    metadata.put("callbackServerPort", Integer.toString(hash));
                    metadata.put("guid", guid);
                }
            }
        } else {
            String callbackPollPeriod = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.pollPeriod");
            if (callbackPollPeriod == null && (callbackPollPeriod = (String)serverLocator.getParameters().get("callbackPollPeriod")) == null) {
                callbackPollPeriod = CALLBACK_POLL_PERIOD_DEFAULT;
            }
            metadata.put("callbackPollPeriod", callbackPollPeriod);
            String reportPollingStatistics = JMSRemotingConnection.getPropertySafely("jboss.messaging.callback.reportPollingStatistics");
            if (reportPollingStatistics != null) {
                metadata.put("reportStatistics", reportPollingStatistics);
            }
        }
        return metadata;
    }

    public static void addInvokerCallbackHandler(Object configurer, Client client, Map initialMetadata, InvokerLocator serverLocator, InvokerCallbackHandler invokerCallbackHandler) throws Throwable {
        String protocol = serverLocator.getProtocol();
        boolean isBisocket = "bisocket".equals(protocol) || "sslbisocket".equals(protocol);
        boolean isSocket = "socket".equals(protocol) || "sslsocket".equals(protocol);
        boolean doPushCallbacks = isBisocket || isSocket;
        Map metadata = JMSRemotingConnection.createCallbackMetadata(doPushCallbacks, initialMetadata, serverLocator);
        if (doPushCallbacks) {
            log.debug(configurer + " is doing push callbacks");
            client.addListener(invokerCallbackHandler, metadata, null, true);
        } else {
            log.debug(configurer + " is simulating push callbacks");
            client.addListener(invokerCallbackHandler, metadata);
        }
    }

    public JMSRemotingConnection(String serverLocatorURI, boolean clientPing) throws Throwable {
        this.serverLocator = new InvokerLocator(serverLocatorURI);
        this.clientPing = clientPing;
        log.debug(this + " created");
    }

    public void start() throws Throwable {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("enableLease", String.valueOf(this.clientPing));
        this.client = new Client(this.serverLocator, config);
        this.client.setSubsystem("JMS");
        if (log.isTraceEnabled()) {
            log.trace(this + " created client");
        }
        this.callbackManager = new CallbackManager();
        this.client.connect();
        this.client.setMarshaller(new JMSWireFormat());
        this.client.setUnMarshaller(new JMSWireFormat());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("datatype", "jms");
        metadata.put("serializationtype", "jms");
        JMSRemotingConnection.addInvokerCallbackHandler(this, this.client, metadata, this.serverLocator, this.callbackManager);
        log.debug(this + " started");
    }

    public void stop() throws Throwable {
        log.debug(this + " closing");
        this.client.removeListener(this.callbackManager);
        this.client.disconnect();
        this.client = null;
        log.debug(this + " closed");
    }

    public Client getRemotingClient() {
        return this.client;
    }

    public CallbackManager getCallbackManager() {
        return this.callbackManager;
    }

    public synchronized boolean isFailed() {
        return this.failed;
    }

    public synchronized void setFailed() {
        this.failed = true;
        this.client.setDisconnectTimeout(0);
        this.client.disconnect();
        try {
            this.client.removeListener(this.callbackManager);
        }
        catch (Throwable t) {
            log.debug(this + " failed to cleanly remove callback manager from the client", t);
        }
        this.client.disconnect();
    }

    public synchronized boolean addConnectionListener(ConsolidatedRemotingConnectionListener listener) {
        if (this.remotingConnectionListener != null) {
            return false;
        }
        this.client.addConnectionListener(listener);
        this.remotingConnectionListener = listener;
        return true;
    }

    public synchronized ConsolidatedRemotingConnectionListener getConnectionListener() {
        return this.remotingConnectionListener;
    }

    public synchronized ConsolidatedRemotingConnectionListener removeConnectionListener() {
        if (this.remotingConnectionListener == null) {
            return null;
        }
        this.client.removeConnectionListener(this.remotingConnectionListener);
        log.debug(this + " removed consolidated connection listener from " + this.client);
        ConsolidatedRemotingConnectionListener toReturn = this.remotingConnectionListener;
        this.remotingConnectionListener = null;
        return toReturn;
    }

    public String toString() {
        return "JMSRemotingConnection[" + this.serverLocator.getLocatorURI() + "]";
    }
}

