/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.client.delegate.ClientConsumerDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.server.endpoint.SessionEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.jms.wireformat.SessionCreateConsumerDelegateResponse;

public class SessionCreateConsumerDelegateRequest
extends RequestSupport {
    private JBossDestination dest;
    private String selector;
    private boolean noLocal;
    private String subName;
    private boolean connectionConsumer;

    public SessionCreateConsumerDelegateRequest() {
    }

    public SessionCreateConsumerDelegateRequest(int objectId, byte version, JBossDestination destination, String selector, boolean noLocal, String subName, boolean connectionConsumer) {
        super(objectId, 301, version);
        this.dest = destination;
        this.selector = selector;
        this.noLocal = noLocal;
        this.subName = subName;
        this.connectionConsumer = connectionConsumer;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.dest = JBossDestination.readDestination(is);
        this.selector = this.readNullableString(is);
        this.noLocal = is.readBoolean();
        this.subName = this.readNullableString(is);
        this.connectionConsumer = is.readBoolean();
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        return new SessionCreateConsumerDelegateResponse((ClientConsumerDelegate)endpoint.createConsumerDelegate(this.dest, this.selector, this.noLocal, this.subName, this.connectionConsumer));
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        JBossDestination.writeDestination(os, this.dest);
        this.writeNullableString(this.selector, os);
        os.writeBoolean(this.noLocal);
        this.writeNullableString(this.subName, os);
        os.writeBoolean(this.connectionConsumer);
        os.flush();
    }
}

