/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.core.message.MessageFactory;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;
import org.jboss.messaging.util.StreamUtils;

class MessageRequest
extends ClusterRequest {
    static final int TYPE = 3;
    private String routingConditionText;
    private Message message;
    private Map queueNameNodeIdMap;

    MessageRequest() {
    }

    MessageRequest(String routingConditionText, Message message, Map queueNameNodeIdMap) {
        this.routingConditionText = routingConditionText;
        this.message = message;
        this.queueNameNodeIdMap = queueNameNodeIdMap;
    }

    Object execute(PostOfficeInternal office) throws Exception {
        office.routeFromCluster(this.message, this.routingConditionText, this.queueNameNodeIdMap);
        return null;
    }

    byte getType() {
        return 3;
    }

    public void read(DataInputStream in) throws Exception {
        this.routingConditionText = in.readUTF();
        byte type = in.readByte();
        this.message = MessageFactory.createMessage(type);
        this.message.read(in);
        this.queueNameNodeIdMap = (Map)StreamUtils.readObject(in, false);
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeUTF(this.routingConditionText);
        out.writeByte(this.message.getType());
        this.message.write(out);
        StreamUtils.writeObject(out, this.queueNameNodeIdMap, true, false);
    }
}

