/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.core.message.MessageFactory;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;

public class PullMessageResultRequest
extends ClusterRequest {
    private static final Logger log = Logger.getLogger(PullMessageResultRequest.class);
    public static final int TYPE = 2;
    private long holdingTxId;
    private String queueName;
    private Message message;
    private int remoteNodeId;

    PullMessageResultRequest() {
    }

    PullMessageResultRequest(int remoteNodeId, long holdingTxId, String queueName, Message message) {
        this.remoteNodeId = remoteNodeId;
        this.holdingTxId = holdingTxId;
        this.queueName = queueName;
        this.message = message;
    }

    Message getMessage() {
        return this.message;
    }

    public void read(DataInputStream in) throws Exception {
        this.remoteNodeId = in.readInt();
        this.holdingTxId = in.readLong();
        this.queueName = in.readUTF();
        byte type = in.readByte();
        this.message = MessageFactory.createMessage(type);
        this.message.read(in);
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.remoteNodeId);
        out.writeLong(this.holdingTxId);
        out.writeUTF(this.queueName);
        out.writeByte(this.message.getType());
        this.message.write(out);
    }

    Object execute(PostOfficeInternal office) throws Throwable {
        office.handleMessagePullResult(this.remoteNodeId, this.holdingTxId, this.queueName, this.message);
        return null;
    }

    byte getType() {
        return 2;
    }
}

