/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.encryption;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.encryption.EncryptionManager;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class EncryptingUnMarshaller
extends SerializableUnMarshaller {
    private static final long serialVersionUID = 1L;
    public static final String DATATYPE = "encrypt";
    private UnMarshaller wrappedUnMarshaller;
    private String cipherAlgorithm = "DES";
    private Cipher cipher = EncryptionManager.getCipher(2, this.cipherAlgorithm);

    public EncryptingUnMarshaller() {
    }

    public EncryptingUnMarshaller(UnMarshaller unMarshaller) {
        this.wrappedUnMarshaller = unMarshaller;
    }

    public void setCipherAlgorithm(String algo) {
        this.cipherAlgorithm = algo;
        this.cipher = EncryptionManager.getCipher(2, this.cipherAlgorithm);
    }

    public Object read(InputStream inputStream, Map metadata) throws IOException, ClassNotFoundException {
        if (this.cipher == null) {
            throw new IllegalStateException("Cipher is null for algo=" + this.cipherAlgorithm);
        }
        CipherInputStream cis = new CipherInputStream(inputStream, this.cipher);
        SerializationManager sm = SerializationStreamFactory.getManagerInstance(this.getSerializationType());
        ObjectInputStream ois = sm.createRegularInput(cis);
        Object obj = null;
        obj = this.wrappedUnMarshaller != null ? this.wrappedUnMarshaller.read(ois, metadata) : super.read(ois, metadata);
        return obj;
    }

    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        EncryptingUnMarshaller um = new EncryptingUnMarshaller(this.wrappedUnMarshaller);
        um.setCipherAlgorithm(this.cipherAlgorithm);
        return um;
    }
}

