/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import com.sun.xacml.Policy;
import com.sun.xacml.ctx.RequestCtx;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import javax.security.jacc.PolicyContext;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
import org.jboss.security.authorization.modules.ejb.EJBXACMLUtil;
import org.jboss.security.authorization.sunxacml.JBossXACMLUtil;

public class EJBXACMLPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    private String ejbName = null;
    private Method ejbMethod = null;
    private Principal principal = null;

    public EJBXACMLPolicyModuleDelegate() {
        log = Logger.getLogger(this.getClass());
        this.trace = log.isTraceEnabled();
    }

    public int authorize(Resource resource) {
        Map map = resource.getMap();
        if (map == null) {
            throw new IllegalStateException("Map from the Resource is null");
        }
        if (map.size() == 0) {
            throw new IllegalStateException("Map from the Resource is size zero");
        }
        PolicyRegistration pr = (PolicyRegistration)map.get("authorizationManager");
        if (pr != null) {
            this.authzManager = pr;
        }
        this.ejbName = (String)map.get("ejb.name");
        this.ejbMethod = (Method)map.get("ejb.method");
        this.principal = (Principal)map.get("ejb.principal");
        return this.process();
    }

    public void setPolicyRegistrationManager(PolicyRegistration authzM) {
        this.authzManager = authzM;
    }

    private int process() {
        int result = -1;
        EJBXACMLUtil util = new EJBXACMLUtil();
        try {
            RequestCtx requestCtx = util.createXACMLRequest(this.ejbName, this.ejbMethod.getName(), this.principal, this.authzManager);
            String contextID = PolicyContext.getContextID();
            Policy policy = (Policy)this.authzManager.getPolicy(contextID, null);
            if (policy == null) {
                if (this.trace) {
                    log.trace("Policy obtained is null for contextID:" + contextID);
                }
                throw new IllegalStateException("Missing xacml policy for contextid:" + contextID);
            }
            result = JBossXACMLUtil.checkXACMLAuthorization(requestCtx, policy);
        }
        catch (Exception e) {
            if (this.trace) {
                log.trace("Exception in processing:", e);
            }
            result = -1;
        }
        return result;
    }
}

