/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.net.URL;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.mx.server.registry.MBeanEntry;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ConfigurationException;
import org.jboss.system.ServiceInstance;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceMetaDataParser;
import org.jboss.util.UnreachableStatementException;
import org.w3c.dom.Element;

public class ServiceCreator {
    private static final Logger log = Logger.getLogger(ServiceCreator.class);
    private static ObjectName MBEAN_REGISTRY = ObjectNameFactory.create("JMImplementation:type=MBeanRegistry");
    private MBeanServer server;

    public static ServiceInstance install(MBeanServer server, ObjectName objectName, ServiceMetaData metaData, Object mbean) throws Exception {
        if (server == null) {
            throw new IllegalArgumentException("Null MBeanServer");
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null ObjectName");
        }
        if (metaData == null && mbean == null) {
            throw new IllegalArgumentException("Either metadata or an mbean object must be supplied");
        }
        if (server.isRegistered(objectName)) {
            throw new DeploymentException("Trying to install an already registered mbean: " + objectName);
        }
        try {
            ServiceInstance result = null;
            if (metaData == null) {
                ObjectInstance instance = server.registerMBean(mbean, objectName);
                result = new ServiceInstance(instance, mbean);
            } else {
                String interfaceName;
                String code = metaData.getCode();
                if (code == null || code.trim().length() == 0) {
                    throw new ConfigurationException("Missing or empty code for mbean " + objectName);
                }
                String xmbeanDD = metaData.getXMBeanDD();
                result = xmbeanDD == null ? ((interfaceName = metaData.getInterfaceName()) != null ? ServiceCreator.installStandardMBean(server, objectName, metaData) : ServiceCreator.installPlainMBean(server, objectName, metaData)) : (xmbeanDD.length() == 0 ? ServiceCreator.installEmbeddedXMBean(server, objectName, metaData) : ServiceCreator.installExternalXMBean(server, objectName, metaData));
            }
            log.debug("Created mbean: " + objectName);
            return result;
        }
        catch (Throwable e) {
            Throwable newE = JMXExceptionDecoder.decode(e);
            try {
                server.unregisterMBean(objectName);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            DeploymentException.rethrowAsDeploymentException("Unable to createMBean for " + objectName, newE);
            throw new UnreachableStatementException();
        }
    }

    private static ServiceInstance installStandardMBean(MBeanServer server, ObjectName objectName, ServiceMetaData metaData) throws Exception {
        ObjectName loaderName = metaData.getClassLoaderName();
        ClassLoader loader = server.getClassLoader(loaderName);
        String code = metaData.getCode();
        ServiceConstructorMetaData constructor = metaData.getConstructor();
        String interfaceName = metaData.getInterfaceName();
        Class<?> intf = loader.loadClass(interfaceName);
        log.debug("About to create bean resource: " + objectName + " with code: " + code + " and interface " + interfaceName);
        Object resource = server.instantiate(code, loaderName, constructor.getParameters(loader), constructor.getSignature());
        log.debug("About to register StandardMBean : " + objectName);
        ObjectInstance instance = server.createMBean(StandardMBean.class.getName(), objectName, loaderName, new Object[]{resource, intf}, new String[]{Object.class.getName(), Class.class.getName()});
        return new ServiceInstance(instance, resource);
    }

    private static ServiceInstance installPlainMBean(MBeanServer server, ObjectName objectName, ServiceMetaData metaData) throws Exception {
        ObjectName loaderName = metaData.getClassLoaderName();
        ClassLoader loader = server.getClassLoader(loaderName);
        String code = metaData.getCode();
        ServiceConstructorMetaData constructor = metaData.getConstructor();
        log.debug("About to create bean: " + objectName + " with code: " + code);
        ObjectInstance instance = server.createMBean(code, objectName, loaderName, constructor.getParameters(loader), constructor.getSignature());
        MBeanEntry entry = (MBeanEntry)server.invoke(MBEAN_REGISTRY, "get", new Object[]{objectName}, new String[]{ObjectName.class.getName()});
        Object resource = entry.getResourceInstance();
        return new ServiceInstance(instance, resource);
    }

    private static ServiceInstance installEmbeddedXMBean(MBeanServer server, ObjectName objectName, ServiceMetaData metaData) throws Exception {
        ObjectName loaderName = metaData.getClassLoaderName();
        ClassLoader loader = server.getClassLoader(loaderName);
        String code = metaData.getCode();
        ServiceConstructorMetaData constructor = metaData.getConstructor();
        log.debug("About to create xmbean object: " + objectName + " with code: " + code + " with embedded descriptor");
        Object resource = server.instantiate(code, loaderName, constructor.getParameters(loader), constructor.getSignature());
        String xmbeanCode = metaData.getXMBeanCode();
        Element mbeanDescriptor = metaData.getXMBeanDescriptor();
        Object[] args = new Object[]{resource, mbeanDescriptor, "-//JBoss//DTD JBOSS XMBEAN 1.0//EN"};
        String[] sig = new String[]{Object.class.getName(), Element.class.getName(), String.class.getName()};
        ObjectInstance instance = server.createMBean(xmbeanCode, objectName, loaderName, args, sig);
        return new ServiceInstance(instance, resource);
    }

    private static ServiceInstance installExternalXMBean(MBeanServer server, ObjectName objectName, ServiceMetaData metaData) throws Exception {
        ObjectName loaderName = metaData.getClassLoaderName();
        ClassLoader loader = server.getClassLoader(loaderName);
        String code = metaData.getCode();
        ServiceConstructorMetaData constructor = metaData.getConstructor();
        String xmbeanDD = metaData.getXMBeanDD();
        log.debug("About to create xmbean object: " + objectName + " with code: " + code + " with descriptor: " + xmbeanDD);
        Object resource = server.instantiate(code, loaderName, constructor.getParameters(loader), constructor.getSignature());
        URL xmbeanddUrl = null;
        try {
            xmbeanddUrl = resource.getClass().getClassLoader().getResource(xmbeanDD);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (xmbeanddUrl == null) {
            xmbeanddUrl = new URL(xmbeanDD);
        }
        String xmbeanCode = metaData.getXMBeanCode();
        Object[] args = new Object[]{resource, xmbeanddUrl};
        String[] sig = new String[]{Object.class.getName(), URL.class.getName()};
        ObjectInstance instance = server.createMBean(xmbeanCode, objectName, loaderName, args, sig);
        return new ServiceInstance(instance, resource);
    }

    public static void uninstall(MBeanServer server, ObjectName objectName) {
        if (server == null) {
            throw new IllegalArgumentException("Null MBeanServer");
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Null ObjectName");
        }
        try {
            log.debug("Removing mbean from server: " + objectName);
            server.unregisterMBean(objectName);
        }
        catch (Throwable t) {
            log.debug("Error unregistering mbean " + objectName, t);
        }
    }

    public ServiceCreator(MBeanServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Null MBeanServer");
        }
        this.server = server;
    }

    public void shutdown() {
        this.server = null;
    }

    public ObjectInstance install(ObjectName mbeanName, ObjectName loaderName, Element mbeanElement) throws Exception {
        if (mbeanName == null) {
            throw new IllegalArgumentException("Null mbeanName");
        }
        if (mbeanElement == null) {
            throw new IllegalArgumentException("Null mbean element");
        }
        ServiceMetaDataParser parser = new ServiceMetaDataParser(mbeanElement);
        List<ServiceMetaData> metaDatas = parser.parse();
        if (metaDatas.isEmpty()) {
            throw new DeploymentException("No mbeans found in passed configuration for " + mbeanName);
        }
        ServiceMetaData metaData = metaDatas.get(0);
        metaData.setClassLoaderName(loaderName);
        ServiceInstance instance = ServiceCreator.install(this.server, mbeanName, metaData, null);
        return instance.getObjectInstance();
    }

    public void remove(ObjectName name) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        ServiceCreator.uninstall(this.server, name);
    }
}

