/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.deployers.spi.deployment.MainDeployer;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.DeploymentRepositoryFactory;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileProfileRepository
implements ProfileRepository {
    private File root;
    DeploymentRepositoryFactory repositoryFactory;
    private MainDeployer mainDeployer;

    public FileProfileRepository() {
        this(null);
    }

    public FileProfileRepository(File root) {
        this.root = root;
    }

    public DeploymentRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(DeploymentRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public File getStoreRoot() {
        return this.root;
    }

    public void setStoreRoot(File root) {
        this.root = root;
    }

    @Override
    public Collection<ProfileKey> getProfileKeys() {
        HashSet<ProfileKey> keys = new HashSet<ProfileKey>();
        for (File profile : this.root.listFiles()) {
            keys.add(new ProfileKey(profile.getName()));
        }
        return keys;
    }

    @Override
    public DeploymentRepository createProfileDeploymentRepository(ProfileKey key) throws Exception {
        DeploymentRepository repository = this.repositoryFactory.getDeploymentRepository(key);
        repository.create();
        return repository;
    }

    @Override
    public DeploymentRepository getProfileDeploymentRepository(ProfileKey key) throws Exception, NoSuchProfileException {
        DeploymentRepository repository = this.repositoryFactory.getDeploymentRepository(key);
        repository.load();
        return repository;
    }

    @Override
    public void removeProfileDeploymentRepository(ProfileKey key) throws Exception, NoSuchProfileException {
        DeploymentRepository repository = this.repositoryFactory.getDeploymentRepository(key);
        repository.remove();
    }
}

