/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TransactionLocalDelegate;
import org.jboss.util.NestedRuntimeException;

public class TransactionLocalDelegateImpl
implements TransactionLocalDelegate {
    protected TransactionManager manager;
    protected static ConcurrentHashMap synchronizationsByTransaction = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TransactionLocalSynchronization getSynchronization(Transaction tx, boolean create) {
        Transaction transaction = tx;
        synchronized (transaction) {
            TransactionLocalSynchronization result = (TransactionLocalSynchronization)synchronizationsByTransaction.get((Object)tx);
            if (result == null && create) {
                result = new TransactionLocalSynchronization(tx);
                try {
                    tx.registerSynchronization(result);
                }
                catch (RollbackException e) {
                    throw new IllegalStateException("Transaction already rolled back or marked for rollback");
                }
                catch (SystemException e) {
                    throw new NestedRuntimeException(e);
                }
                synchronizationsByTransaction.put((Object)tx, (Object)result);
            }
            return result;
        }
    }

    protected static void removeSynchronization(Transaction tx) {
        synchronizationsByTransaction.remove((Object)tx);
    }

    public TransactionLocalDelegateImpl(TransactionManager manager) {
        this.manager = manager;
    }

    public void lock(TransactionLocal local, Transaction tx) throws InterruptedException {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx, true);
        sync.lock(local);
    }

    public void unlock(TransactionLocal local, Transaction tx) {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx, false);
        if (sync == null) {
            throw new IllegalStateException("No synchronization found tx=" + tx + " local=" + local);
        }
        sync.unlock(local);
    }

    public Object getValue(TransactionLocal local, Transaction tx) {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx, false);
        if (sync == null) {
            return null;
        }
        return sync.getValue(local);
    }

    public void storeValue(TransactionLocal local, Transaction tx, Object value) {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx, true);
        sync.setValue(local, value);
    }

    public boolean containsValue(TransactionLocal local, Transaction tx) {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx, false);
        if (sync == null) {
            return false;
        }
        return sync.containsValue(local);
    }

    protected static class TransactionLocalSynchronization
    implements Synchronization {
        protected Transaction tx;
        private Map valuesByLocal = Collections.synchronizedMap(new HashMap());
        protected ReentrantLock reentrantLock = new ReentrantLock();

        public TransactionLocalSynchronization(Transaction tx) {
            this.tx = tx;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            TransactionLocalDelegateImpl.removeSynchronization(this.tx);
            this.valuesByLocal.clear();
        }

        public void lock(Object local) throws InterruptedException {
            boolean locked = this.reentrantLock.attempt(60000L);
            if (!locked) {
                throw new IllegalStateException("Failed to acquire lock within 60 seconds.");
            }
        }

        public void unlock(Object local) {
            this.reentrantLock.release();
        }

        public Object getValue(Object local) {
            return this.valuesByLocal.get(local);
        }

        public void setValue(Object local, Object value) {
            this.valuesByLocal.put(local, value);
        }

        public boolean containsValue(Object local) {
            return this.valuesByLocal.containsKey(local);
        }
    }
}

