/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Service;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxrpc.Style;
import org.jboss.ws.core.soap.EnvelopeBuilderDOM;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.SOAPPartImpl;
import org.jboss.ws.core.soap.attachment.MultipartRelatedDecoder;
import org.jboss.ws.core.utils.IOUtils;

public class MessageFactoryImpl
extends MessageFactory {
    private static Logger log = Logger.getLogger(MessageFactoryImpl.class);
    private String envNamespace;
    private Service.Mode serviceMode;
    private Style style;
    private boolean dynamic;

    public MessageFactoryImpl() {
        this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
    }

    public MessageFactoryImpl(String protocol) throws SOAPException {
        if ("SOAP 1.1 Protocol".equals(protocol) || "SOAP 1.1 Protocol".equals(protocol)) {
            this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
        } else if ("SOAP 1.2 Protocol".equals(protocol)) {
            this.envNamespace = "http://www.w3.org/2003/05/soap-envelope";
        } else if ("Dynamic Protocol".equals(protocol)) {
            this.dynamic = true;
        } else {
            throw new SOAPException("Unknown protocol: " + protocol);
        }
    }

    public String getEnvNamespace() {
        return this.envNamespace;
    }

    public void setEnvNamespace(String envelopeURI) {
        this.envNamespace = envelopeURI;
    }

    public Style getStyle() {
        if (this.style == null) {
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext != null && msgContext.getOperationMetaData() != null) {
                this.style = msgContext.getOperationMetaData().getStyle();
            }
            log.trace("Using style: " + this.style);
        }
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Service.Mode getServiceMode() {
        return this.serviceMode;
    }

    public void setServiceMode(Service.Mode serviceMode) {
        this.serviceMode = serviceMode;
    }

    public SOAPMessage createMessage() throws SOAPException {
        if (this.dynamic) {
            throw new UnsupportedOperationException();
        }
        SOAPMessageImpl soapMessage = new SOAPMessageImpl();
        SOAPPartImpl soapPart = (SOAPPartImpl)soapMessage.getSOAPPart();
        new SOAPEnvelopeImpl(soapPart, this.envNamespace);
        return soapMessage;
    }

    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream ins) throws IOException, SOAPException {
        return this.createMessage(mimeHeaders, ins, false);
    }

    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream ins, boolean ignoreParseError) throws IOException, SOAPException {
        if (mimeHeaders == null) {
            mimeHeaders = new MimeHeaders();
        } else if (log.isTraceEnabled()) {
            Iterator itMimeHeaders = mimeHeaders.getAllHeaders();
            while (itMimeHeaders.hasNext()) {
                MimeHeader mh = (MimeHeader)itMimeHeaders.next();
                log.trace(mh);
            }
        }
        ContentType contentType = MessageFactoryImpl.getContentType(mimeHeaders);
        if (log.isDebugEnabled()) {
            log.debug("createMessage: [contentType=" + contentType + "]");
        }
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            IOUtils.copyStream(baos, ins);
            byte[] bytes = baos.toByteArray();
            log.trace("createMessage\n" + new String(bytes));
            ins = new ByteArrayInputStream(bytes);
        }
        Collection<AttachmentPart> attachments = null;
        if (this.isMultipartRelatedContent(contentType)) {
            MultipartRelatedDecoder decoder;
            try {
                decoder = new MultipartRelatedDecoder(contentType);
                decoder.decodeMultipartRelatedMessage(ins);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SOAPException("Cannot decode multipart related message", (Throwable)ex);
            }
            ins = decoder.getRootPart().getDataHandler().getInputStream();
            attachments = decoder.getRelatedParts();
        } else if (!this.isSoapContent(contentType)) {
            throw new SOAPException("Unsupported content type: " + contentType);
        }
        SOAPMessageImpl soapMessage = new SOAPMessageImpl();
        if (mimeHeaders != null) {
            soapMessage.setMimeHeaders(mimeHeaders);
        }
        if (attachments != null) {
            soapMessage.setAttachments(attachments);
        }
        EnvelopeBuilderDOM envBuilder = new EnvelopeBuilderDOM(this.getStyle());
        envBuilder.build((SOAPMessage)soapMessage, ins, ignoreParseError);
        return soapMessage;
    }

    private static ContentType getContentType(MimeHeaders headers) throws SOAPException {
        ContentType contentType = null;
        try {
            String[] type = headers.getHeader("Content-Type");
            contentType = type != null ? new ContentType(type[0]) : new ContentType("text/xml");
            return contentType;
        }
        catch (ParseException e) {
            throw new SOAPException("Could not parse content type:" + (Object)((Object)e));
        }
    }

    private boolean isSoapContent(ContentType type) {
        String baseType = type.getBaseType();
        return "text/xml".equalsIgnoreCase(baseType) || "application/soap+xml".equalsIgnoreCase(baseType);
    }

    private boolean isMultipartRelatedContent(ContentType type) {
        String baseType = type.getBaseType();
        return "multipart/related".equalsIgnoreCase(baseType);
    }
}

