/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.ws.handler.MessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
import org.jboss.ws.core.soap.DOMContent;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.ObjectContent;
import org.jboss.ws.core.soap.SAAJVisitor;
import org.jboss.ws.core.soap.SOAPContent;
import org.jboss.ws.core.soap.SOAPContentAccess;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.XMLContent;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.ws.core.utils.DOMWriter;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class SOAPContentElement
extends SOAPElementImpl
implements SOAPContentAccess {
    private static Logger log = Logger.getLogger(SOAPContentElement.class);
    public static final QName GENERIC_PARAM_NAME = new QName("genericParam");
    public static final QName GENERIC_RETURN_NAME = new QName("genericReturn");
    private ParameterMetaData paramMetaData;
    private SOAPContent soapContent = new DOMContent(this);
    private boolean lockDOMExpansion = false;

    public SOAPContentElement(Name name) {
        super(name);
    }

    public SOAPContentElement(QName qname) {
        super(qname);
    }

    public SOAPContentElement(SOAPElementImpl element) {
        super(element);
    }

    public ParameterMetaData getParamMetaData() {
        if (this.paramMetaData == null) {
            throw new IllegalStateException("Parameter meta data not available");
        }
        return this.paramMetaData;
    }

    public void setParamMetaData(ParameterMetaData paramMetaData) {
        this.paramMetaData = paramMetaData;
    }

    public QName getXmlType() {
        return this.getParamMetaData().getXmlType();
    }

    public Class getJavaType() {
        return this.getParamMetaData().getJavaType();
    }

    private void transitionTo(SOAPContent.State nextState) {
        if (nextState != this.soapContent.getState()) {
            log.debug("-----------------------------------");
            log.debug("Transitioning from " + (Object)((Object)this.soapContent.getState()) + " to " + (Object)((Object)nextState));
            this.lockDOMExpansion = true;
            this.soapContent = this.soapContent.transitionTo(nextState);
            this.lockDOMExpansion = false;
            log.debug("-----------------------------------");
        }
    }

    public Source getPayload() {
        if (this.soapContent.getState() == SOAPContent.State.OBJECT_VALID) {
            this.transitionTo(SOAPContent.State.DOM_VALID);
        }
        return this.soapContent.getPayload();
    }

    public XMLFragment getXMLFragment() {
        this.transitionTo(SOAPContent.State.XML_VALID);
        return this.soapContent.getXMLFragment();
    }

    public void setXMLFragment(XMLFragment xmlFragment) {
        this.soapContent = new XMLContent(this);
        this.soapContent.setXMLFragment(xmlFragment);
    }

    public Object getObjectValue() {
        this.transitionTo(SOAPContent.State.OBJECT_VALID);
        return this.soapContent.getObjectValue();
    }

    public void setObjectValue(Object objValue) {
        this.soapContent = new ObjectContent(this);
        this.soapContent.setObjectValue(objValue);
    }

    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        log.trace("addChildElement: " + child);
        this.expandToDOM();
        return super.addChildElement(child);
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        log.trace("addChildElement: [localName=" + localName + ",prefix=" + prefix + "]");
        this.expandToDOM();
        return super.addChildElement(localName, prefix);
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        log.trace("addChildElement: [localName=" + localName + ",prefix=" + prefix + ",uri=" + uri + "]");
        this.expandToDOM();
        return super.addChildElement(localName, prefix, uri);
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        log.trace("addChildElement: [name=" + name + "]");
        this.expandToDOM();
        return super.addChildElement(name);
    }

    public SOAPElement addChildElement(String name) throws SOAPException {
        log.trace("addChildElement: [name=" + name + "]");
        this.expandToDOM();
        return super.addChildElement(name);
    }

    public SOAPElement addTextNode(String value) throws SOAPException {
        log.trace("addTextNode: [value=" + value + "]");
        this.expandToDOM();
        return super.addTextNode(value);
    }

    public Iterator getChildElements() {
        log.trace("getChildElements");
        this.expandToDOM();
        return super.getChildElements();
    }

    public Iterator getChildElements(Name name) {
        log.trace("getChildElements: [name=" + name + "]");
        this.expandToDOM();
        return super.getChildElements(name);
    }

    public void removeContents() {
        log.trace("removeContents");
        this.expandToDOM();
        super.removeContents();
    }

    public Iterator getAllAttributes() {
        return super.getAllAttributes();
    }

    public String getAttribute(String name) {
        return super.getAttribute(name);
    }

    public Attr getAttributeNode(String name) {
        return super.getAttributeNode(name);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return super.getAttributeNodeNS(namespaceURI, localName);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return super.getAttributeNS(namespaceURI, localName);
    }

    public String getAttributeValue(Name name) {
        return super.getAttributeValue(name);
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        log.trace("addAttribute: [name=" + name + ",value=" + value + "]");
        this.expandToDOM();
        return super.addAttribute(name, value);
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String nsURI) {
        log.trace("addNamespaceDeclaration: [prefix=" + prefix + ",nsURI=" + nsURI + "]");
        this.expandToDOM();
        return super.addNamespaceDeclaration(prefix, nsURI);
    }

    public Name getElementName() {
        return super.getElementName();
    }

    public NodeList getElementsByTagName(String name) {
        log.trace("getElementsByTagName: [name=" + name + "]");
        this.expandToDOM();
        return super.getElementsByTagName(name);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        log.trace("getElementsByTagName: [nsURI=" + namespaceURI + ",localName=" + localName + "]");
        this.expandToDOM();
        return super.getElementsByTagNameNS(namespaceURI, localName);
    }

    public String getEncodingStyle() {
        return super.getEncodingStyle();
    }

    public Iterator getNamespacePrefixes() {
        return super.getNamespacePrefixes();
    }

    public String getNamespaceURI(String prefix) {
        return super.getNamespaceURI(prefix);
    }

    public TypeInfo getSchemaTypeInfo() {
        return super.getSchemaTypeInfo();
    }

    public String getTagName() {
        return super.getTagName();
    }

    public Iterator getVisibleNamespacePrefixes() {
        return super.getVisibleNamespacePrefixes();
    }

    public boolean hasAttribute(String name) {
        return super.hasAttribute(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return super.hasAttributeNS(namespaceURI, localName);
    }

    public boolean removeAttribute(Name name) {
        log.trace("removeAttribute: " + name.getQualifiedName());
        this.expandToDOM();
        return super.removeAttribute(name);
    }

    public void removeAttribute(String name) throws DOMException {
        log.trace("removeAttribute: " + name);
        this.expandToDOM();
        super.removeAttribute(name);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        log.trace("removeAttribute: " + oldAttr.getNodeName());
        this.expandToDOM();
        return super.removeAttributeNode(oldAttr);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        log.trace("removeAttributeNS: {" + namespaceURI + "}" + localName);
        this.expandToDOM();
        super.removeAttributeNS(namespaceURI, localName);
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        log.trace("removeNamespaceDeclaration: " + prefix);
        this.expandToDOM();
        return super.removeNamespaceDeclaration(prefix);
    }

    public void setAttribute(String name, String value) throws DOMException {
        log.trace("setAttribute: [name=" + name + ",value=" + value + "]");
        this.expandToDOM();
        super.setAttribute(name, value);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        log.trace("setAttributeNode: " + newAttr);
        this.expandToDOM();
        return super.setAttributeNode(newAttr);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        log.trace("setAttributeNodeNS: " + newAttr);
        this.expandToDOM();
        return super.setAttributeNodeNS(newAttr);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        log.trace("setAttribute: [nsURI=" + namespaceURI + ",name=" + qualifiedName + ",value=" + value + "]");
        this.expandToDOM();
        super.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        log.trace("setIdAttribute: [name=" + name + ",value=" + isId + "]");
        this.expandToDOM();
        super.setIdAttribute(name, isId);
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        log.trace("setIdAttributeNode: [idAttr=" + idAttr + ",value=" + isId + "]");
        this.expandToDOM();
        super.setIdAttributeNode(idAttr, isId);
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        log.trace("setIdAttributeNS: [nsURI=" + namespaceURI + ",name=" + localName + ",value=" + isId + "]");
        this.expandToDOM();
        super.setIdAttributeNS(namespaceURI, localName, isId);
    }

    public Node appendChild(Node newChild) throws DOMException {
        log.trace("appendChild: " + newChild);
        this.expandToDOM();
        return super.appendChild(newChild);
    }

    public Node cloneNode(boolean deep) {
        log.trace("cloneNode: deep=" + deep);
        this.expandToDOM();
        return super.cloneNode(deep);
    }

    public NodeList getChildNodes() {
        log.trace("getChildNodes");
        this.expandToDOM();
        return super.getChildNodes();
    }

    public Node getFirstChild() {
        log.trace("getFirstChild");
        this.expandToDOM();
        return super.getFirstChild();
    }

    public Node getLastChild() {
        log.trace("getLastChild");
        this.expandToDOM();
        return super.getLastChild();
    }

    public String getValue() {
        log.trace("getValue");
        this.expandToDOM();
        return super.getValue();
    }

    public boolean hasChildNodes() {
        log.trace("hasChildNodes");
        this.expandToDOM();
        return super.hasChildNodes();
    }

    public Node removeChild(Node oldChild) throws DOMException {
        log.trace("removeChild: " + oldChild);
        this.expandToDOM();
        return super.removeChild(oldChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        log.trace("replaceChild: [new=" + newChild + ",old=" + oldChild + "]");
        this.expandToDOM();
        return super.replaceChild(newChild, oldChild);
    }

    private void expandToDOM() {
        if (!this.lockDOMExpansion) {
            this.transitionTo(SOAPContent.State.DOM_VALID);
        }
    }

    public void setValue(String value) {
        log.trace("setValue: " + value);
        this.expandToDOM();
        super.setValue(value);
    }

    public NamedNodeMap getAttributes() {
        return super.getAttributes();
    }

    public boolean hasAttributes() {
        return super.hasAttributes();
    }

    public void writeElement(Writer writer) throws IOException {
        if (MessageContextAssociation.peekMessageContext() != null) {
            this.handleMTOMTransitions();
        }
        if (this.soapContent instanceof DOMContent) {
            new DOMWriter(writer).print((Node)((Object)this));
        } else {
            this.transitionTo(SOAPContent.State.XML_VALID);
            this.soapContent.getXMLFragment().writeTo(writer);
        }
    }

    public void handleMTOMTransitions() {
        if (!this.isXOPParameter()) {
            return;
        }
        boolean domContentState = this.soapContent instanceof DOMContent;
        if (!XOPContext.isMTOMEnabled()) {
            log.debug("MTOM disabled: Force inline XOP data");
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            msgContext.put(CommonMessageContext.ALLOW_EXPAND_TO_DOM, (Object)Boolean.TRUE);
            if (msgContext instanceof MessageContextJAXWS) {
                ((MessageContextJAXWS)msgContext).setScope(CommonMessageContext.ALLOW_EXPAND_TO_DOM, MessageContext.Scope.APPLICATION);
            }
            this.expandToDOM();
        } else if (domContentState && XOPContext.isMTOMEnabled()) {
            log.debug("MTOM enabled: Restore XOP data");
            XOPContext.restoreXOPDataDOM(this);
        }
    }

    boolean isXOPParameter() {
        return this.paramMetaData != null && this.paramMetaData.isXOP();
    }

    public void accept(SAAJVisitor visitor) {
        visitor.visitSOAPContentElement(this);
    }
}

