package ch9Tests;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;

import junit.framework.TestCase;

import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.tool.hbm2ddl.SchemaExport;

import ch9.codedEntities.Coach;
import ch9.codedEntities.Player;
import ch9.codedEntities.School;
import ch9.codedEntities.Team;


/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 61136 $
 */
public class Ch9TestCase extends TestCase
{
	public Ch9TestCase()
	{
		super("Ch9TestCase");
	}

	public void testConcurrency() throws Exception
	{
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("eyrollesEntityManager");
		EntityManager em1 = emf.createEntityManager();
		EntityManager em2 = emf.createEntityManager();
		
		EntityTransaction tx1 = em1.getTransaction();
		EntityTransaction tx2 = em2.getTransaction();
		
		tx1.begin();
		Team team = new Team("cascade test team");
		Player player = new Player ("cascade player test");
		School school = new School ("cascade school test");
		Coach coach= new Coach ("cascade test coach");
		player.setSchool(school);
		team.getPlayers().add(player);
		team.setCoach(coach);
		em1.persist(team);
		tx1.commit();
	
		tx1.begin();
		tx2.begin();		
		Team t1 = em1.find(Team.class, new Integer(1));
		t1.setName("new name1");
		Team t2 = em2.find(Team.class, new Integer(1));
		t2.setName("new name2");
		tx2.commit();
		tx1.commit();
		em1.close();
		em2.close();
	
	}

	public void testConcurrency2() throws Exception
	{
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("eyrollesEntityManager");
		EntityManager em1 = emf.createEntityManager();
		EntityManager em2 = emf.createEntityManager();
		
		EntityTransaction tx1 = em1.getTransaction();
		EntityTransaction tx2 = em2.getTransaction();
		
		tx1.begin();
		Team team = new Team("cascade test team");
		Player player = new Player ("cascade player test");
		School school = new School ("cascade school test");
		Coach coach= new Coach ("cascade test coach");
		player.setSchool(school);
		team.getPlayers().add(player);
		team.setCoach(coach);
		em1.persist(team);
		tx1.commit();
		
	
		tx1.begin();
		tx2.begin();		
		Team t1 = em1.find(Team.class, new Integer(1));
		Team t2 = em2.find(Team.class, new Integer(1));
		em1.remove(t1);
		t2.setName("new name2");
		tx1.commit();
		tx2.commit();
		
		em1.close();
		em2.close();
	
	}

	public void testQuery() throws Exception
	{
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("eyrollesEntityManager");
		EntityManager em1 = emf.createEntityManager();
		EntityTransaction tx1 = em1.getTransaction();
		tx1.begin();
		//Query q = em1.createQuery("from Player p where p.").;
		
		tx1.commit();
		em1.close();
	}


}
