/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import com.opensymphony.oscache.base.Config;
import java.util.Properties;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.OSCache;
import org.hibernate.cache.Timestamper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.StringHelper;

public class OSCacheProvider
implements CacheProvider {
    public static final String OSCACHE_REFRESH_PERIOD = "refresh.period";
    public static final String OSCACHE_CRON = "cron";
    public static final String OSCACHE_CAPACITY = "capacity";
    private static final Properties OSCACHE_PROPERTIES = new Config().getProperties();

    public Cache buildCache(String region, Properties properties) throws CacheException {
        int refreshPeriod = PropertiesHelper.getInt(StringHelper.qualify(region, OSCACHE_REFRESH_PERIOD), OSCACHE_PROPERTIES, -1);
        String cron = OSCACHE_PROPERTIES.getProperty(StringHelper.qualify(region, OSCACHE_CRON));
        OSCache cache = new OSCache(refreshPeriod, cron, region);
        Integer capacity = PropertiesHelper.getInteger(StringHelper.qualify(region, OSCACHE_CAPACITY), OSCACHE_PROPERTIES);
        if (capacity != null) {
            cache.setCacheCapacity(capacity);
        }
        return cache;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) throws CacheException {
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

