/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreImple;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.utils.FileLock;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public abstract class FileSystemStore
extends ObjectStoreImple {
    static final char unixSeparator = '/';
    static boolean rewriteSeparator;
    protected boolean syncWrites = true;
    private String fullStoreName;
    private String localStoreRoot;
    private boolean isValid;
    private static final int MAXPNAMELEN = 255;
    private static final int MAXNAMELENGTH = 255;
    private static final int SLOP = 9;
    private static boolean doSync;
    private static Hashtable fileCache;
    private static int createRetry;
    private static int createTimeout;

    public FileSystemStore(String locationOfStore, int ss) {
        super(ss);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 16L, "FileSystemStore.FileSystemStore(" + locationOfStore + ")");
        }
        this.fullStoreName = null;
        this.localStoreRoot = null;
        this.isValid = true;
        try {
            this.setupStore(locationOfStore);
        }
        catch (ObjectStoreException e) {
            this.isValid = false;
            tsLogger.arjLogger.warn(e.getMessage());
            throw new FatalError(e.toString());
        }
    }

    public FileSystemStore(ObjectName objName) {
        super(objName);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 16L, "FileSystemStore.FileSystemStore(" + objName + ")");
        }
        this.fullStoreName = null;
        this.localStoreRoot = null;
        this.isValid = true;
        try {
            this.setupStore("");
        }
        catch (ObjectStoreException e) {
            this.isValid = false;
            tsLogger.arjLogger.warn(e.getMessage());
            throw new FatalError(e.toString());
        }
    }

    public String getStoreName() {
        return this.localStoreRoot;
    }

    public InputObjectState read_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.read_committed(" + storeUid + ", " + tName + ")");
        }
        return this.read_state(storeUid, tName, 11);
    }

    public InputObjectState read_uncommitted(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.read_uncommitted(" + storeUid + ", " + tName + ")");
        }
        return this.read_state(storeUid, tName, 10);
    }

    public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.remove_committed(" + storeUid + ", " + tName + ")");
        }
        return this.remove_state(storeUid, tName, 11);
    }

    public boolean remove_uncommitted(Uid storeUid, String tName) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.remove_uncommitted(" + storeUid + ", " + tName + ")");
        }
        return this.remove_state(storeUid, tName, 10);
    }

    public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.write_committed(" + storeUid + ", " + tName + ")");
        }
        return this.write_state(storeUid, tName, state, 11);
    }

    public boolean write_uncommitted(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.write_uncommitted(" + storeUid + ", " + tName + ", " + state + ")");
        }
        return this.write_state(storeUid, tName, state, 10);
    }

    public final synchronized boolean storeValid() {
        return this.isValid;
    }

    public final synchronized void makeInvalid() {
        this.isValid = false;
    }

    public final synchronized void makeValid() {
        this.isValid = true;
    }

    public boolean allObjUids(String tName, InputObjectState state, int match) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.allObjUids(" + tName + ", " + state + ", " + match + ")");
        }
        String directory = null;
        OutputObjectState store = new OutputObjectState();
        if (tName != null && tName.charAt(0) == File.separatorChar) {
            String s = tName.substring(1, tName.length());
            directory = new String(this.fullStoreName + s);
        } else {
            directory = new String(this.fullStoreName + tName);
        }
        File f = new File(directory);
        String[] entry = f.list();
        if (entry != null && entry.length > 0) {
            for (int i = 0; i < entry.length; ++i) {
                try {
                    Uid aUid = new Uid(entry[i], true);
                    if (!aUid.valid() || aUid.equals(Uid.nullUid())) {
                        String revealed = this.revealedId(entry[i]);
                        aUid = this.present(revealed, entry) ? null : new Uid(revealed);
                    }
                    if (aUid == null || !aUid.valid() || !aUid.notEquals(Uid.nullUid()) || match != 0 && !this.isType(aUid, tName, match)) continue;
                    aUid.pack(store);
                    continue;
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (IOException e) {
                    throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_2a"));
                }
            }
        }
        try {
            Uid.nullUid().pack(store);
        }
        catch (IOException e) {
            throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_3"));
        }
        state.setBuffer(store.buffer());
        store = null;
        return true;
    }

    public boolean allTypes(InputObjectState foundTypes) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 4L, 16L, "FileSystemStore.allTypes(" + foundTypes + ")");
        }
        boolean result = true;
        String directory = new String(this.fullStoreName);
        File f = new File(directory);
        String[] entry = f.list();
        if (entry == null) {
            return true;
        }
        OutputObjectState store = new OutputObjectState();
        for (int i = 0; i < entry.length; ++i) {
            if (this.supressEntry(entry[i])) continue;
            File tmpFile = new File(directory + File.separator + entry[i]);
            if (tmpFile.isDirectory()) {
                try {
                    store.packString(entry[i]);
                    result = this.allTypes(store, entry[i]);
                }
                catch (IOException e) {
                    throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_4"));
                }
            }
            tmpFile = null;
        }
        try {
            store.packString("");
        }
        catch (IOException e) {
            throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_5"));
        }
        foundTypes.setBuffer(store.buffer());
        return result;
    }

    public synchronized void packInto(OutputBuffer buff) throws IOException {
        if (this.localStoreRoot != null && this.localStoreRoot.compareTo("") == 0) {
            buff.packString(null);
            return;
        }
        buff.packString(this.localStoreRoot);
    }

    public synchronized void unpackFrom(InputBuffer buff) throws IOException {
        try {
            this.setupStore(buff.unpackString());
        }
        catch (ObjectStoreException e) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_6"));
        }
    }

    public ClassName className() {
        return ArjunaNames.Implementation_ObjectStore_FileSystemStore();
    }

    public static ClassName name() {
        return ArjunaNames.Implementation_ObjectStore_FileSystemStore();
    }

    protected abstract InputObjectState read_state(Uid var1, String var2, int var3) throws ObjectStoreException;

    protected abstract boolean remove_state(Uid var1, String var2, int var3) throws ObjectStoreException;

    protected abstract boolean write_state(Uid var1, String var2, OutputObjectState var3, int var4) throws ObjectStoreException;

    protected final synchronized void syncOn() {
        doSync = true;
    }

    protected final synchronized void syncOff() {
        doSync = false;
    }

    protected final synchronized boolean synchronousWrites() {
        return doSync && this.syncWrites;
    }

    protected synchronized boolean lock(File fd, int lmode, boolean create) {
        FileLock fileLock = new FileLock(fd);
        return fileLock.lock(lmode, create);
    }

    protected synchronized boolean unlock(File fd) {
        FileLock fileLock = new FileLock(fd);
        return fileLock.unlock();
    }

    protected FileSystemStore(int ss) {
        super(ss);
        this.fullStoreName = null;
        this.localStoreRoot = null;
        this.isValid = true;
    }

    protected boolean allTypes(OutputObjectState foundTypes, String root) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "FileSystemStore.allTypes(" + foundTypes + ", " + root + ")");
        }
        boolean result = true;
        String directory = new String(this.fullStoreName + File.separator + root);
        File f = new File(directory);
        String[] entry = f.list();
        if (entry != null && entry.length > 0) {
            for (int i = 0; i < entry.length; ++i) {
                if (this.supressEntry(entry[i])) continue;
                try {
                    String pack;
                    File tmpFile = new File(directory + File.separator + entry[i]);
                    if (tmpFile.isDirectory() && (pack = this.truncate(entry[i])).length() > 0) {
                        foundTypes.packString(root + File.separator + pack);
                        result = this.allTypes(foundTypes, root + File.separator + pack);
                    }
                    tmpFile = null;
                    continue;
                }
                catch (IOException e) {
                    throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_7"));
                }
            }
        }
        return result;
    }

    protected String genPathName(Uid objUid, String tName, int m) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "FileSystemStore.genPathName(" + objUid + ", " + tName + ", " + m + ")");
        }
        String storeName = this.locateStore(this.getStoreName());
        String cPtr = null;
        String fname = null;
        String os = objUid.fileStringForm();
        if (tName == null || tName.length() == 0) {
            cPtr = "";
        } else {
            cPtr = tName;
            if (rewriteSeparator && cPtr.indexOf(47) != -1) {
                cPtr = cPtr.replace('/', File.separatorChar);
            }
        }
        if (cPtr.charAt(0) == File.separatorChar) {
            cPtr = cPtr.substring(1, cPtr.length());
        }
        if ((fname = cPtr.charAt(cPtr.length() - 1) != File.separatorChar ? storeName + cPtr + File.separator + os : storeName + cPtr + os).charAt(fname.length() - 1) == File.separatorChar) {
            fname = fname.substring(0, fname.length() - 2);
        }
        return fname;
    }

    protected synchronized boolean setupStore(String localOSRoot) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "FileSystemStore.setupStore(" + localOSRoot + ")");
        }
        this.isValid = true;
        if (localOSRoot == null) {
            localOSRoot = "";
        }
        this.localStoreRoot = localOSRoot;
        this.fullStoreName = this.locateStore(this.localStoreRoot);
        if (this.fullStoreName == null || !this.createHierarchy(this.fullStoreName)) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_1", new Object[]{this.fullStoreName});
            }
            this.isValid = false;
        }
        return this.isValid;
    }

    protected boolean supressEntry(String name) {
        return name.compareTo(".") == 0 || name.compareTo("..") == 0;
    }

    protected String truncate(String value) {
        return value;
    }

    protected final synchronized boolean createHierarchy(String path) throws ObjectStoreException {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "FileSystemStore.createHierarchy(" + path + ")");
        }
        if (path != null && path.length() > 0) {
            File f = null;
            if (path.charAt(path.length() - 1) != File.separatorChar) {
                int index = path.lastIndexOf(File.separator);
                if (index <= 0) {
                    return true;
                }
                f = new File(path.substring(0, index));
            } else {
                f = new File(path);
            }
            int retryLimit = createRetry;
            do {
                if (f.exists()) {
                    return true;
                }
                if (!f.mkdirs()) {
                    if (--retryLimit == 0) {
                        return false;
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(createTimeout);
                    }
                    catch (Exception ex) {}
                    continue;
                }
                return true;
            } while (!f.exists() && retryLimit > 0);
            return f.exists();
        }
        throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_8"));
    }

    protected final boolean exists(String path) {
        if (this.shareStatus == 14 && fileCache.get(path) != null) {
            return true;
        }
        File f = new File(path);
        boolean doesExist = f.exists();
        if (doesExist) {
            this.addToCache(path);
        }
        return doesExist;
    }

    protected final void addToCache(String fname) {
        if (this.shareStatus == 14) {
            fileCache.put(fname, fname);
        }
    }

    protected final void removeFromCache(String fname) {
        this.removeFromCache(fname, true);
    }

    protected final void removeFromCache(String fname, boolean warn) {
        if (this.shareStatus == 14 && fileCache.remove(fname) == null && warn && tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore_2", new Object[]{fname});
        }
    }

    private final boolean present(String id, String[] list2) {
        for (int i = 0; i < list2.length; ++i) {
            if (!list2[i].equals(id)) continue;
            return true;
        }
        return false;
    }

    static {
        String timeout;
        String retry;
        rewriteSeparator = false;
        doSync = true;
        fileCache = new Hashtable();
        createRetry = 100;
        createTimeout = 100;
        String syncOpt = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.objectStoreSync");
        if (syncOpt != null) {
            if (syncOpt.compareTo("OFF") == 0) {
                doSync = false;
            }
        } else {
            doSync = true;
        }
        if (File.separatorChar != '/') {
            rewriteSeparator = true;
        }
        if ((retry = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.hierarchyRetry")) != null) {
            try {
                Integer i = new Integer(retry);
                createRetry = i;
                if (createRetry < 0) {
                    createRetry = 100;
                }
            }
            catch (NumberFormatException e) {
                throw new FatalError("Invalid retry for hierarchy creation: " + createRetry);
            }
            catch (Exception e) {
                throw new FatalError(e.toString());
            }
        }
        if ((timeout = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.hierarchyTimeout")) != null) {
            try {
                Integer i = new Integer(timeout);
                createTimeout = i;
                if (createTimeout < 0) {
                    createTimeout = 100;
                }
            }
            catch (NumberFormatException e) {
                throw new FatalError("Invalid timeout for hierarchy creation: " + createTimeout);
            }
            catch (Exception e) {
                throw new FatalError(e.toString());
            }
        }
    }
}

