/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.AspectManager;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.classpool.AOPClassPoolRepository;
import org.jboss.aop.deployment.JBossClassPool;
import org.jboss.aop.deployment.LoaderRepositoryUrlUtil;
import org.jboss.mx.loading.HeirarchicalLoaderRepository3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;

public class ScopedJBossClassPool
extends JBossClassPool {
    static final LoaderRepositoryUrlUtil LOADER_REPOSITORY_UTIL = new LoaderRepositoryUrlUtil();
    WeakReference repository = null;
    LoaderRepositoryUrlUtil.UrlInfo urlInfo;
    ThreadLocal lastPool = new ThreadLocal();

    protected ScopedJBossClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, File tmp, URL tmpURL) {
        super(cl, src, repository, tmp, tmpURL);
        boolean parentFirst = false;
        LoaderRepository loaderRepository = null;
        ClassLoader prnt = cl;
        while (prnt != null) {
            if (prnt instanceof RepositoryClassLoader) {
                loaderRepository = ((RepositoryClassLoader)prnt).getLoaderRepository();
                if (!(loaderRepository instanceof HeirarchicalLoaderRepository3)) break;
                parentFirst = ((HeirarchicalLoaderRepository3)loaderRepository).getUseParentFirst();
                break;
            }
            prnt = cl.getParent();
        }
        this.childFirstLookup = !parentFirst;
    }

    private HeirarchicalLoaderRepository3 getRepository() {
        ClassLoader cl = this.getClassLoader0();
        if (cl != null) {
            return (HeirarchicalLoaderRepository3)((RepositoryClassLoader)cl).getLoaderRepository();
        }
        return null;
    }

    private URL getResourceUrlForClass(String resourcename) {
        HeirarchicalLoaderRepository3 repo = this.getRepository();
        return repo.getResource(resourcename, super.getClassLoader());
    }

    private boolean isMine(URL url) {
        HeirarchicalLoaderRepository3 repo = this.getRepository();
        if (repo != null && url != null) {
            this.urlInfo = LOADER_REPOSITORY_UTIL.getURLInfo(this.getRepository(), this.urlInfo);
            URL[] myUrls = this.urlInfo.getLocalUrls();
            String resource = url.toString();
            for (int i = 0; i < myUrls.length; ++i) {
                if (resource.indexOf(myUrls[i].toString()) < 0) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public CtClass getCached(String classname) {
        if (classname == null) {
            return null;
        }
        if (this.generatedClasses.get((Object)classname) != null) {
            return super.getCached(classname);
        }
        String resourcename = this.getResourceName(classname);
        URL url = this.getResourceUrlForClass(resourcename);
        boolean isMine = this.isMine(url);
        if (isMine) {
            if (this.childFirstLookup) {
                CtClass clazz = super.getCachedLocally(classname);
                if (clazz == null && (clazz = this.createCtClass(classname, false)) != null) {
                    this.lockInCache(clazz);
                }
                if (clazz != null) {
                    return clazz;
                }
            }
            return super.getCached(classname);
        }
        try {
            ClassPool pool = this.getCorrectPoolForResource(url);
            if (pool != this.lastPool.get()) {
                this.lastPool.set(pool);
                CtClass ctClass = pool.get(classname);
                return ctClass;
            }
        }
        catch (NotFoundException e) {
        }
        catch (StackOverflowError e) {
            throw e;
        }
        finally {
            this.lastPool.set(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPool getCorrectPoolForResource(URL url) {
        Map map = AspectManager.getRegisteredCLs();
        synchronized (map) {
            for (AOPClassPool candidate : AspectManager.getRegisteredCLs().values()) {
                if (candidate.isUnloadedClassLoader()) {
                    AspectManager.instance().unregisterClassLoader(candidate.getClassLoader());
                    continue;
                }
                if (!(candidate.getClassLoader() instanceof RepositoryClassLoader)) continue;
                RepositoryClassLoader rcl = (RepositoryClassLoader)candidate.getClassLoader();
                URL[] urls = rcl.getClasspath();
                String resource = url.toString();
                for (int i = 0; i < urls.length; ++i) {
                    if (resource.indexOf(urls[i].toString()) < 0) continue;
                    return candidate;
                }
            }
        }
        return AOPClassPool.createAOPClassPool(ClassPool.getDefault(), AOPClassPoolRepository.getInstance());
    }
}

