/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.dbc.condition;

import bsh.EvalError;
import bsh.Interpreter;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.dbc.DesignByContractAspect;
import org.jboss.aspects.dbc.condition.Condition;

public abstract class ExecutableCondition
extends Condition {
    public ExecutableCondition(String condExpr, Class clazz, boolean isStatic) {
        super(condExpr, clazz, isStatic);
    }

    public void evaluateCondition(DesignByContractAspect aspect, Invocation inv, Object[] args, Object ret) {
        try {
            if (DesignByContractAspect.verbose) {
                System.out.println("[dbc] Evaluate condition : '" + this.originalExpr + "' for: " + this.executableObject());
            }
            Interpreter interpreter = new Interpreter();
            for (String beanshellname : this.parameterLookup.keySet()) {
                String originalname = (String)this.parameterLookup.get(beanshellname);
                Object value = this.getValueForToken(inv, args, ret, originalname);
                interpreter.set(beanshellname, value);
                if (!DesignByContractAspect.verbose) continue;
                System.out.println("[dbc] Setting $" + originalname + " to " + value + (value != null ? " (type: " + value.getClass().getName() + ")" : ""));
            }
            Boolean eval = (Boolean)interpreter.eval(this.condExpr);
            if (!eval.booleanValue()) {
                System.out.println("CONDITION BROKEN: " + this.originalExpr + " - " + this.executableObject());
                throw new RuntimeException("Condition " + this.originalExpr + " was broken " + "for: " + this.executableObject());
            }
        }
        catch (EvalError e) {
            throw new RuntimeException("There was an error in the expression: " + this.originalExpr, e);
        }
    }

    public String toString() {
        return this.executableObject() + ":" + super.toString();
    }

    protected Object getValueForToken(Invocation invocation, Object[] args, Object rtn, String token) {
        if (this.isPredefinedToken(token)) {
            return this.getValueForPredefinedToken(invocation, rtn, token);
        }
        try {
            int i = Integer.parseInt(token);
            return args[i];
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid token '$" + token + "' in condition: " + this.originalExpr);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("invalid parameter number '$" + token + "' in condition: " + this.originalExpr + ". " + this.executableObject() + " takes " + this.parameterTypes().length);
        }
    }

    protected abstract boolean isPredefinedToken(String var1);

    protected abstract Object getValueForPredefinedToken(Invocation var1, Object var2, String var3);

    protected abstract Object executableObject();

    protected abstract Class[] parameterTypes();
}

