/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.config.plugins;

import java.lang.reflect.Type;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.classadapter.spi.ClassAdapterFactory;
import org.jboss.classadapter.spi.DependencyBuilder;
import org.jboss.config.spi.Configuration;
import org.jboss.joinpoint.spi.JoinpointFactoryBuilder;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.NestedRuntimeException;

public abstract class AbstractConfiguration
implements Configuration {
    private BeanInfoFactory beanInfoFactory;
    private ClassAdapterFactory classAdapterFactory;
    private TypeInfoFactory typeInfoFactory;
    private JoinpointFactoryBuilder joinpointFactoryBuilder;
    private DependencyBuilder dependencyBuilder;

    public BeanInfo getBeanInfo(String className, ClassLoader cl) throws ClassNotFoundException {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(className, cl);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    public BeanInfo getBeanInfo(Class clazz) {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(clazz);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    public BeanInfo getBeanInfo(TypeInfo typeInfo) {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(typeInfo);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    public ClassInfo getClassInfo(String className, ClassLoader cl) throws ClassNotFoundException {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(className, cl);
        return classAdapter.getClassInfo();
    }

    public ClassInfo getClassInfo(Class clazz) {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(clazz);
        return classAdapter.getClassInfo();
    }

    public TypeInfo getTypeInfo(Type type) {
        return this.getTypeInfoFactory().getTypeInfo(type);
    }

    public TypeInfoFactory getTypeInfoFactory() {
        if (this.typeInfoFactory == null) {
            try {
                this.typeInfoFactory = this.createDefaultTypeInfoFactory();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create TypeInfoFactory", t);
            }
        }
        return this.typeInfoFactory;
    }

    public JoinpointFactoryBuilder getJoinpointFactoryBuilder() {
        if (this.joinpointFactoryBuilder == null) {
            try {
                this.joinpointFactoryBuilder = this.createDefaultJoinpointFactoryBuilder();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create JoinpointFactoryBuilder", t);
            }
        }
        return this.joinpointFactoryBuilder;
    }

    public DependencyBuilder getDependencyBuilder() {
        if (this.dependencyBuilder == null) {
            try {
                this.dependencyBuilder = this.createDefaultDependencyBuilder();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create DependencyBuilder", t);
            }
        }
        return this.dependencyBuilder;
    }

    protected BeanInfoFactory getBeanInfoFactory() {
        if (this.beanInfoFactory == null) {
            try {
                this.beanInfoFactory = this.createDefaultBeanInfoFactory();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error creating bean info factory");
            }
        }
        return this.beanInfoFactory;
    }

    protected ClassAdapterFactory getClassAdapterFactory() {
        if (this.classAdapterFactory == null) {
            try {
                this.classAdapterFactory = this.createDefaultClassAdapterFactory();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error creating class adapter");
            }
        }
        return this.classAdapterFactory;
    }

    protected abstract BeanInfoFactory createDefaultBeanInfoFactory() throws Throwable;

    protected abstract ClassAdapterFactory createDefaultClassAdapterFactory() throws Throwable;

    protected abstract TypeInfoFactory createDefaultTypeInfoFactory() throws Throwable;

    protected abstract JoinpointFactoryBuilder createDefaultJoinpointFactoryBuilder() throws Throwable;

    protected abstract DependencyBuilder createDefaultDependencyBuilder() throws Throwable;
}

