/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers.helpers;

import java.util.Set;
import org.jboss.deployers.plugins.deployers.helpers.AbstractRealDeployer;
import org.jboss.deployers.plugins.deployers.helpers.SimpleDeploymentVisitor;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentDeployer<D, C>
extends AbstractRealDeployer<D> {
    private SimpleDeploymentVisitor<C> compVisitor;
    private Class<C> componentType;

    public AbstractComponentDeployer() {
        this.setRelativeOrder(7000);
    }

    protected void setComponentVisitor(SimpleDeploymentVisitor<C> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.compVisitor = visitor;
        this.componentType = visitor.getVisitorType();
        if (this.componentType == null) {
            throw new IllegalArgumentException("Null visitor type");
        }
    }

    @Override
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        super.deploy(unit);
        try {
            this.deployComponents(unit);
        }
        catch (Throwable t) {
            this.undeployComponents(unit);
            throw DeploymentException.rethrowAsDeploymentException("Error deploying: " + unit.getName(), t);
        }
    }

    @Override
    public void undeploy(DeploymentUnit unit) {
        super.undeploy(unit);
        this.undeployComponents(unit);
    }

    protected void deployComponents(DeploymentUnit unit) throws DeploymentException {
        if (this.compVisitor == null) {
            return;
        }
        Set<C> components = unit.getAllMetaData(this.componentType);
        for (C component : components) {
            this.compVisitor.deploy(unit, component);
        }
    }

    protected void undeployComponents(DeploymentUnit unit) {
        if (this.compVisitor == null) {
            return;
        }
        Set<C> components = unit.getAllMetaData(this.componentType);
        for (C component : components) {
            this.compVisitor.undeploy(unit, component);
        }
    }
}

